/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;

public class PasteHandler
extends AbstractCommandHandler {
    @Override
    protected Command getCommand() {
        List<EObject> selection = this.getSelectedElements();
        List allStrategies = PasteStrategyManager.getInstance().getAllActiveStrategies();
        if (selection.size() == 1) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (IStrategy iStrategy : allStrategies) {
                Command emfCommand = ((IPasteStrategy)iStrategy).getSemanticCommand((EditingDomain)this.getEditingDomain(), selection.get(0), PapyrusClipboard.getInstance());
                if (emfCommand == null) continue;
                compoundCommand.append(emfCommand);
            }
            return compoundCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    protected boolean computeEnabled() {
        boolean isEnabled = false;
        if (!PapyrusClipboard.getInstance().isEmptyWithNoAdditionalData() && this.getSelectedElements().size() == 1) {
            isEnabled = !EMFHelper.isReadOnly((EObject)this.getSelectedElements().get(0));
        }
        return isEnabled;
    }
}

