/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.services;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.ui.services.SaveLayoutBeforeClose;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class ResourceUpdateService
implements IService,
IPartListener {
    protected ServicesRegistry registry;
    protected ModelSet modelSet;
    static int[] handledTypes = new int[]{1, 4, 2};
    protected boolean isSaving;
    protected ConcurrentMap<IMultiDiagramEditor, Job> pendingEditorCloseJobs = Maps.newConcurrentMap();
    private final ISaveEventListener preSaveListener = new ISaveEventListener(){

        @Override
        public void doSaveAs(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = true;
        }

        @Override
        public void doSave(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = true;
        }
    };
    private final ISaveEventListener postSaveListener = new ISaveEventListener(){

        @Override
        public void doSaveAs(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = false;
        }

        @Override
        public void doSave(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = false;
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Collection<Resource> changedResources = new ArrayList<Resource>();
                    protected Collection<Resource> removedResources = new ArrayList<Resource>();

                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            if (delta.getKind() == 2 || delta.getKind() == 4) {
                                URI resourceURI = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
                                Resource resource = (this).ResourceUpdateService.this.modelSet.getResource(resourceURI, false);
                                if (resource == null) {
                                    URI pluginURI = URI.createPlatformPluginURI((String)delta.getFullPath().toString(), (boolean)true);
                                    resource = (this).ResourceUpdateService.this.modelSet.getResource(pluginURI, false);
                                }
                                if (resource != null) {
                                    if (delta.getKind() == 2) {
                                        this.removedResources.add(resource);
                                    } else {
                                        delta.getFlags();
                                        if ((delta.getFlags() & 0x100) != 0 && !(this).ResourceUpdateService.this.isSaving) {
                                            this.changedResources.add(resource);
                                        }
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    ResourceUpdateService.this.handleResourcesRemoved(visitor.getRemovedResources());
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    ResourceUpdateService.this.handleResourceChanged(visitor.getChangedResources());
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
        }
    };

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        ((ILifeCycleEventsProvider)this.registry.getService(ILifeCycleEventsProvider.class)).addAboutToDoSaveListener(this.preSaveListener);
        ((ILifeCycleEventsProvider)this.registry.getService(ILifeCycleEventsProvider.class)).addPostDoSaveListener(this.postSaveListener);
    }

    public void disposeService() throws ServiceException {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.modelSet = null;
    }

    protected void closeEditor() {
        this.closeEditor(Collections.emptyList(), false);
    }

    protected void closeEditor(final Collection<? extends Resource> triggeringResources, final boolean reopen) {
        try {
            IWorkbenchPartSite site;
            UIJob closeEditorJob;
            IMultiDiagramEditor editor;
            if (!reopen) {
                this.registry.remove((Object)SaveLayoutBeforeClose.class.getName());
            }
            if ((editor = (IMultiDiagramEditor)this.registry.getService(IMultiDiagramEditor.class)) != null && this.pendingEditorCloseJobs.putIfAbsent(editor, (Job)(closeEditorJob = new UIJob((site = editor.getSite()).getShell().getDisplay(), NLS.bind((String)"Reload editor {0}", (Object)editor.getTitle())){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ResourceUpdateService.this.pendingEditorCloseJobs.remove(editor);
                    IStatus result = Status.OK_STATUS;
                    monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                    try {
                        IReloadableEditor.ReloadReason reason = reopen ? IReloadableEditor.ReloadReason.RESOURCES_CHANGED : IReloadableEditor.ReloadReason.RESOURCES_DELETED;
                        IReloadableEditor.DirtyPolicy dirtyPolicy = IReloadableEditor.DirtyPolicy.getDefault();
                        if (!reopen && !editor.isDirty()) {
                            URI principalURI = ResourceUpdateService.this.modelSet.getURIWithoutExtension();
                            for (Resource next : triggeringResources) {
                                if (!next.getURI().trimFileExtension().equals(principalURI)) continue;
                                dirtyPolicy = IReloadableEditor.DirtyPolicy.DO_NOT_SAVE;
                                break;
                            }
                        }
                        try {
                            IReloadableEditor.Adapter.getAdapter(editor).reloadEditor(triggeringResources, reason, dirtyPolicy);
                        }
                        catch (CoreException e) {
                            result = e.getStatus();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return result;
                }
            })) == null) {
                IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class);
                progressService.schedule((Job)closeEditorJob);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    protected void handleResourcesRemoved(Collection<Resource> emfResources) {
        this.closeEditor(emfResources, false);
    }

    protected void handleResourceChanged(Collection<Resource> emfResources) {
        this.closeEditor(emfResources, true);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

