/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.ui.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;

public class TreeListFiles
extends SimpleFileVisitor<Path> {
    private String rootDir = "";
    private TreeParent invisibleRoot = new TreeParent("", "");

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        TreeParent p1 = (TreeParent)this.invisibleRoot.getChild(file.getParent().toString());
        if (file.getFileName().toString().contains(".arg_diagram") || file.getFileName().toString().contains(".gsn1_diagram")) {
            p1.addChild(new TreeObject(file.getFileName().toString(), String.valueOf(file.getParent().toString()) + "\\" + file.getFileName().toString()));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        System.out.format("Directory preVisit: %s%n", dir);
        TreeParent p1 = new TreeParent(dir.getFileName().toString(), String.valueOf(dir.getParent().toString()) + "\\" + dir.getFileName().toString());
        Path parent = dir.getParent();
        String sParent = "";
        if (parent != null) {
            sParent = parent.toString();
        }
        TreeParent tParent = this.invisibleRoot;
        if (dir.toString().compareTo(this.rootDir) != 0 && sParent.compareTo("") != 0) {
            tParent = (TreeParent)this.invisibleRoot.getChild(sParent);
        }
        if (!dir.getFileName().toString().startsWith(".") && tParent != null) {
            tParent.addChild(p1);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        System.err.println(exc);
        return FileVisitResult.CONTINUE;
    }

    public TreeParent getRoot() {
        return this.invisibleRoot;
    }

    public TreeListFiles(String sRootDir) {
        this.rootDir = sRootDir;
    }

    public class TreeObject
    implements IAdaptable {
        private String name;
        private String Fullname;
        private TreeParent parent;

        public TreeObject(String name, String fullname) {
            this.name = name;
            this.Fullname = fullname;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.Fullname;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    public class TreeParent
    extends TreeObject {
        private ArrayList<TreeObject> children;

        public TreeParent(String name, String fullname) {
            super(name, fullname);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public TreeObject getChild(String sName) {
            TreeObject res = null;
            if (this.getFullName().compareTo(sName) == 0) {
                return this;
            }
            for (TreeObject child : this.children) {
                if (child.getFullName().compareTo(sName) == 0) {
                    return child;
                }
                if (child.getClass().getSimpleName().compareTo("TreeParent") == 0) {
                    res = ((TreeParent)child).getChild(sName);
                }
                if (res != null) break;
            }
            return res;
        }
    }
}

