/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperationUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SignalUtil;
import org.eclipse.papyrus.uml.tools.utils.TypedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;

public class MessageLabelHelper
extends StereotypedElementLabelHelper {
    public static final Collection<String> DEFAULT_LABEL_DISPLAY = Arrays.asList("name", "parametersName", "parametersType", "returnType");
    private static MessageLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    protected MessageLabelHelper() {
        this.masks.put("visibility", "Visibility");
        this.masks.put("name", "Name");
        this.masks.put("parametersName", "Parameters Name");
        this.masks.put("parametersDirection", "Parameters Direction");
        this.masks.put("parametersType", "Parameters Type");
        this.masks.put("returnType", "Return Type");
        this.masks.put("parametersMultiplicity", "Parameters Multiplicity");
        this.masks.put("parametersDefault", "Parameters Default Value");
        this.masks.put("derived", "Parameters Value");
        this.masks.put("parametersModifiers", "Parameters Modifiers");
        this.masks.put("modifiers", "Modifiers");
    }

    public static MessageLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new MessageLabelHelper();
        }
        return labelHelper;
    }

    public Message getUMLElement(GraphicalEditPart editPart) {
        EObject e = ((View)editPart.getModel()).getElement();
        if (e instanceof Message) {
            return (Message)e;
        }
        return null;
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        Message e;
        if (editPart instanceof LabelEditPart) {
            editPart = (GraphicalEditPart)editPart.getParent();
        }
        Collection displayValue = DEFAULT_LABEL_DISPLAY;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        if ((e = this.getUMLElement(editPart)) == null) {
            return null;
        }
        NamedElement signature = e.getSignature();
        if (signature instanceof Operation) {
            return OperationUtil.getCustomLabel(e, (Operation)signature, displayValue);
        }
        if (signature instanceof Signal) {
            return SignalUtil.getCustomLabel(e, (Signal)signature, displayValue);
        }
        if (signature != null) {
            return signature.getName();
        }
        return this.getMessageLabel(e, displayValue);
    }

    private String getMessageLabel(Message message, Collection<String> displayValue) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(message.getName());
        EList arguments = message.getArguments();
        if (arguments.size() > 0 && (displayValue.contains("parametersName") || displayValue.contains("derived"))) {
            buffer.append("(");
            int i = 0;
            while (i < arguments.size()) {
                String value;
                String type;
                if (i > 0) {
                    buffer.append(", ");
                }
                ValueSpecification arg = (ValueSpecification)arguments.get(i);
                if (displayValue.contains("parametersType") && (type = TypedElementUtil.getTypeAsString((TypedElement)arg)) != null) {
                    buffer.append(type);
                }
                boolean showEqualMark = false;
                if (displayValue.contains("parametersName")) {
                    buffer.append(" ");
                    String name = StringHelper.trimToEmpty((String)arg.getName());
                    buffer.append(name);
                    if (name.trim().length() > 0) {
                        showEqualMark = true;
                    }
                }
                if (displayValue.contains("derived") && (value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)arg)) != null) {
                    if (showEqualMark) {
                        buffer.append(" = ");
                    }
                    buffer.append(value);
                }
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Collection<String> getDefaultValue() {
        return DEFAULT_LABEL_DISPLAY;
    }
}

