/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.edit.policies;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorPlugin;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorUtil;
import org.eclipse.opencert.sam.arg.arg.diagram.part.Messages;
import org.eclipse.opencert.sam.arg.arg.impl.ArgumentationImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class OpenFileDiagramEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (!(targetEditPart.getModel() instanceof View)) {
            return null;
        }
        View view = (View)targetEditPart.getModel();
        Style link = view.getStyle(NotationPackage.eINSTANCE.getHintedDiagramLinkStyle());
        if (!(link instanceof HintedDiagramLinkStyle)) {
            return null;
        }
        return new ICommandProxy((ICommand)new OpenFileDiagramCommand((HintedDiagramLinkStyle)link));
    }

    private static class OpenFileDiagramCommand
    extends AbstractTransactionalCommand {
        private final HintedDiagramLinkStyle diagramFacet;

        OpenFileDiagramCommand(HintedDiagramLinkStyle linkStyle) {
            super(TransactionUtil.getEditingDomain((EObject)linkStyle), Messages.CommandName_OpenDiagram, null);
            this.diagramFacet = linkStyle;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                URI uri;
                String editorName;
                Diagram diagram = this.getDiagramToOpen();
                if (diagram == null) {
                    diagram = this.intializeNewDiagram();
                }
                if ((editorName = (uri = EcoreUtil.getURI((EObject)diagram)).toFileString()) == null && (diagram.getName() == null || diagram.getName().compareTo("") == 0)) {
                    throw new ExecutionException("Can't open diagram '");
                }
                URIEditorInput editorInput = new URIEditorInput(uri, editorName);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)editorInput, this.getEditorID());
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't open diagram", (Throwable)ex);
            }
        }

        protected Diagram getDiagramToOpen() {
            return this.diagramFacet.getDiagramLink();
        }

        private boolean copyToFile(String contentSourceFile, File destFile) throws IOException {
            BufferedWriter writer = new BufferedWriter(new FileWriter(destFile));
            writer.write(contentSourceFile);
            return true;
        }

        private boolean copyFile(File sourceFile, File destFile) throws IOException {
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                } else if (destination != null) {
                    destination.close();
                }
            }
            return true;
        }

        protected Diagram intializeNewDiagram() throws ExecutionException {
            String finalDiagramLocation = "";
            String modulesDir = Platform.getPreferencesService().getString("org.eclipse.opencert.sam.preferences", "modulePathPreference", "Modules Dir wrong", null);
            if (modulesDir.compareTo("Modules Dir wrong") == 0) {
                throw new ExecutionException("Can't create diagram due to wrong Modules Dir");
            }
            URI modulesDirURI = URI.createPlatformResourceURI((String)modulesDir, (boolean)false);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(modulesDirURI.lastSegment());
            ShapeImpl sh = (ShapeImpl)this.diagramFacet.eContainer();
            ArgumentationImpl argImpl = (ArgumentationImpl)sh.basicGetElement();
            if (argImpl == null || argImpl.getId() == null) {
                throw new ExecutionException("Can't create diagram null.arg_diagram");
            }
            String name = argImpl.getId();
            String location = modulesDir.concat(argImpl.getLocation());
            File locationFile = null;
            if (location != null) {
                locationFile = new File(location);
            }
            Diagram d = null;
            if (location == null || location.isEmpty() || locationFile == null || !locationFile.exists()) {
                String diagramFName;
                String diagramName = String.valueOf(name) + ".arg_diagram";
                String modelName = String.valueOf(name) + ".arg";
                URI projectPluginDiagramURI = URI.createPlatformResourceURI((String)"org.eclipse.opencert.sam.arg.diagram", (boolean)false);
                ResourcesPlugin.getWorkspace().getRoot().getProject(projectPluginDiagramURI.lastSegment());
                String emptyDiagram = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><notation:Diagram xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:arg=\"arg\" xmlns:notation=\"http://www.eclipse.org/gmf/runtime/1.0.2/notation\" xmi:id=\"_n3jlgPBwEeKfGOouoiya7g\" type=\"Arg\" name=\"empty.arg_diagram\" measurementUnit=\"Pixel\"> <styles xmi:type=\"notation:DiagramStyle\" xmi:id=\"_n3jlgfBwEeKfGOouoiya7g\"/><element xmi:type=\"arg:Case\" href=\"empty.arg#/\"/> </notation:Diagram>";
                String emptyModel = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><arg:Case xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:arg=\"arg\"/>";
                File file2 = new File(String.valueOf(modulesDir) + "\\" + diagramName);
                File file2M = new File(String.valueOf(modulesDir) + "\\" + modelName);
                try {
                    this.copyToFile(emptyDiagram, file2);
                    this.copyToFile(emptyModel, file2M);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                finalDiagramLocation = diagramFName = project.getFile(diagramName).getFullPath().toString();
                String modelFName = project.getFile(modelName).getFullPath().toString();
                URI diagramURI = URI.createPlatformResourceURI((String)diagramFName, (boolean)false);
                URI modelURI = URI.createPlatformResourceURI((String)modelFName, (boolean)false);
                Resource diagramResource = ArgDiagramEditorUtil.createDiagram(diagramURI, modelURI, (IProgressMonitor)new NullProgressMonitor());
                d = (Diagram)diagramResource.getContents().get(0);
            } else {
                String diagramFName;
                finalDiagramLocation = diagramFName = location;
                URI diagramURI = URI.createFileURI((String)diagramFName);
                ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
                System.out.println("Loaded " + diagramURI);
                Resource diagramResource = resourceSet.getResource(diagramURI, true);
                d = (Diagram)diagramResource.getContents().get(0);
            }
            String locationprop = (String)argImpl.eGet((EStructuralFeature)ArgPackage.Literals.ARGUMENTATION__LOCATION);
            if (locationprop == null || locationprop.isEmpty() || locationprop == "") {
                String nombre = finalDiagramLocation.substring(finalDiagramLocation.lastIndexOf("/"), finalDiagramLocation.length());
                String finalDiagramLocation2 = String.valueOf(modulesDir) + nombre;
                argImpl.eSet((EStructuralFeature)ArgPackage.Literals.ARGUMENTATION__LOCATION, (Object)finalDiagramLocation2);
            }
            if (d == null) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind");
            }
            this.diagramFacet.setDiagramLink(d);
            assert (this.diagramFacet.eResource() != null);
            EObject container = this.diagramFacet.eContainer();
            while (container instanceof View) {
                ((View)container).persist();
                container = container.eContainer();
            }
            try {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            for (Resource nextResource : OpenFileDiagramCommand.this.diagramFacet.eResource().getResourceSet().getResources()) {
                                if (!nextResource.isLoaded() || OpenFileDiagramCommand.this.getEditingDomain().isReadOnly(nextResource)) continue;
                                nextResource.save(ArgDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (IOException ex) {
                            throw new InvocationTargetException(ex, "Save operation failed");
                        }
                    }
                }.run(null);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            return d;
        }

        protected EObject getDiagramDomainElement() {
            return ((View)this.diagramFacet.eContainer()).getElement();
        }

        protected PreferencesHint getPreferencesHint() {
            return ArgDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }

        protected String getDiagramKind() {
            return "Arg";
        }

        protected String getEditorID() {
            return "org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorID";
        }
    }
}

