/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.internal.cdo.object.CDOObjectReferenceImpl;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTransactionRequest
extends CDOClientRequestWithMonitoring<CDOSessionProtocol.CommitTransactionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionRequest.class);
    private static long sleepMillisForTesting = 0L;
    private CDOIDProvider idProvider;
    private int commitNumber;
    private String commitComment;
    private boolean releaseLocks;
    private CDOCommitData commitData;
    private Collection<CDOLob<?>> lobs;
    private Collection<CDOLockState> locksOnNewObjects;
    private int viewID;
    private InternalCDOTransaction transaction;
    private boolean clearResourcePathCache;

    public CommitTransactionRequest(CDOClientProtocol protocol, InternalCDOTransaction.InternalCDOCommitContext context) {
        this(protocol, 11, context);
    }

    public CommitTransactionRequest(CDOClientProtocol protocol, short signalID, InternalCDOTransaction.InternalCDOCommitContext context) {
        super(protocol, signalID);
        this.transaction = context.getTransaction();
        InternalCDOSession.CommitToken commitToken = this.transaction.getCommitToken();
        if (commitToken != null) {
            this.commitNumber = commitToken.getCommitNumber();
        }
        this.commitComment = context.getCommitComment();
        this.releaseLocks = context.isAutoReleaseLocks();
        this.idProvider = context.getTransaction();
        this.commitData = context.getCommitData();
        this.lobs = context.getLobs();
        this.locksOnNewObjects = context.getLocksOnNewObjects();
        this.viewID = context.getViewID();
    }

    protected int getMonitorTimeoutSeconds() {
        CDONet4jSession session = (CDONet4jSession)this.getSession();
        return session.options().getCommitTimeout();
    }

    @Override
    protected CDOIDProvider getIDProvider() {
        return this.idProvider;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        this.requestingTransactionInfo(out);
        this.requestingCommit(out);
    }

    protected void requestingTransactionInfo(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
    }

    protected void requestingCommit(CDODataOutput out) throws IOException {
        List newPackageUnits = this.commitData.getNewPackageUnits();
        List newObjects = this.commitData.getNewObjects();
        List changedObjects = this.commitData.getChangedObjects();
        List detachedObjects = this.commitData.getDetachedObjects();
        out.writeLong(this.getLastUpdateTime());
        out.writeBoolean(this.releaseLocks);
        out.writeInt(this.commitNumber);
        out.writeString(this.commitComment);
        out.writeInt(newPackageUnits.size());
        out.writeInt(this.locksOnNewObjects.size());
        out.writeInt(newObjects.size());
        out.writeInt(changedObjects.size());
        out.writeInt(detachedObjects.size());
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new package units", new Object[]{newPackageUnits.size()});
        }
        for (CDOPackageUnit newPackageUnit : newPackageUnits) {
            out.writeCDOPackageUnit(newPackageUnit, true);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} locks on new objects", new Object[]{this.locksOnNewObjects.size()});
        }
        for (CDOLockState lockState : this.locksOnNewObjects) {
            out.writeCDOLockState(lockState);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} new objects", new Object[]{newObjects.size()});
        }
        for (CDOIDAndVersion newObject : newObjects) {
            out.writeCDORevision((CDORevision)newObject, -1);
            if (sleepMillisForTesting == 0L) continue;
            ConcurrencyUtil.sleep((long)sleepMillisForTesting);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} dirty objects", new Object[]{changedObjects.size()});
        }
        CDORepositoryInfo repositoryInfo = this.getSession().getRepositoryInfo();
        CDOID rootResourceID = repositoryInfo.getRootResourceID();
        for (CDORevisionKey changedObject : changedObjects) {
            CDORevisionDelta delta = (CDORevisionDelta)changedObject;
            if (!this.clearResourcePathCache && AbstractCDOView.canHaveResourcePathImpact((CDORevisionDelta)delta, (CDOID)rootResourceID)) {
                this.clearResourcePathCache = true;
            }
            out.writeCDORevisionDelta(delta);
        }
        out.writeBoolean(this.clearResourcePathCache);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} detached objects", new Object[]{detachedObjects.size()});
        }
        boolean auditing = repositoryInfo.isSupportingAudits();
        boolean branching = repositoryInfo.isSupportingBranches();
        boolean ensuringReferentialIntegrity = repositoryInfo.isEnsuringReferentialIntegrity();
        CDOBranch transactionBranch = this.getBranch();
        for (CDOIDAndVersion detachedObject : detachedObjects) {
            CDOBranch branch;
            CDOID id = detachedObject.getID();
            out.writeCDOID(id);
            if (auditing || ensuringReferentialIntegrity) {
                EClass eClass = this.getObjectType(id);
                out.writeCDOClassifierRef((EClassifier)eClass);
            }
            if (!auditing) continue;
            int version = detachedObject.getVersion();
            if (branching && detachedObject instanceof CDORevisionKey && (branch = ((CDORevisionKey)detachedObject).getBranch()) != transactionBranch) {
                out.writeInt(-version);
                out.writeCDOBranch(branch);
                continue;
            }
            out.writeInt(version);
        }
        this.requestingLobs();
    }

    protected void requestingLobs() throws IOException {
        ExtendedDataOutputStream out = this.getRequestStream();
        out.writeInt(this.lobs.size());
        for (CDOLob<?> lob : this.lobs) {
            out.writeByteArray(lob.getID());
            long size = lob.getSize();
            if (lob instanceof CDOBlob) {
                CDOBlob blob = (CDOBlob)lob;
                out.writeLong(size);
                IOUtil.copyBinary((InputStream)blob.getContents(), (OutputStream)out, (long)size);
                continue;
            }
            CDOClob clob = (CDOClob)lob;
            out.writeLong(-size);
            IOUtil.copyCharacter((Reader)clob.getContents(), (Writer)new OutputStreamWriter((OutputStream)out), (long)size);
        }
    }

    protected long getLastUpdateTime() {
        return this.transaction.getLastUpdateTime();
    }

    protected CDOBranch getBranch() {
        return this.transaction.getBranch();
    }

    protected EClass getObjectType(CDOID id) {
        CDOObject object = this.transaction.getObject(id);
        return object.eClass();
    }

    @Override
    protected CDOSessionProtocol.CommitTransactionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        CDOSessionProtocol.CommitTransactionResult result = this.confirmingCheckError(in);
        if (result != null) {
            return result;
        }
        result = this.confirmingResult(in);
        this.confirmingMappingNewObjects(in, result);
        this.confirmingNewLockStates(in, result);
        this.confirmingNewPermissions(in, result);
        return result;
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingCheckError(CDODataInput in) throws IOException {
        boolean success = in.readBoolean();
        if (success) {
            return null;
        }
        CDOSessionProtocol.CommitTransactionResult result = new CDOSessionProtocol.CommitTransactionResult();
        result.setIDProvider(this.idProvider);
        result.setClearResourcePathCache(this.clearResourcePathCache);
        result.setRollbackReason(in.readByte());
        result.setRollbackMessage(in.readString());
        result.setBranchPoint(in.readCDOBranchPoint());
        result.setPreviousTimeStamp(in.readLong());
        int size = in.readInt();
        if (size != 0) {
            ArrayList<CDOObjectReferenceImpl> xRefs = new ArrayList<CDOObjectReferenceImpl>(size);
            result.setXRefs(xRefs);
            int i = 0;
            while (i < size) {
                CDOIDReference idReference = in.readCDOIDReference();
                xRefs.add(new CDOObjectReferenceImpl((CDOView)this.transaction, idReference));
                ++i;
            }
        }
        return result;
    }

    protected CDOSessionProtocol.CommitTransactionResult confirmingResult(CDODataInput in) throws IOException {
        CDOSessionProtocol.CommitTransactionResult result = new CDOSessionProtocol.CommitTransactionResult();
        result.setIDProvider(this.idProvider);
        result.setClearResourcePathCache(this.clearResourcePathCache);
        result.setBranchPoint(in.readCDOBranchPoint());
        result.setPreviousTimeStamp(in.readLong());
        result.setSecurityImpact(in.readByte());
        return result;
    }

    protected void confirmingMappingNewObjects(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        CDOID id;
        while (!CDOIDUtil.isNull((CDOID)(id = in.readCDOID()))) {
            if (id instanceof CDOIDTemp) {
                CDOIDTemp oldID = (CDOIDTemp)id;
                CDOID newID = in.readCDOID();
                result.addIDMapping((CDOID)oldID, newID);
                continue;
            }
            throw new ClassCastException("Not a temporary ID: " + id);
        }
    }

    protected void confirmingNewLockStates(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        int n = in.readInt();
        CDOLockState[] newLockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            newLockStates[i] = in.readCDOLockState();
            ++i;
        }
        result.setNewLockStates(newLockStates);
    }

    protected void confirmingNewPermissions(CDODataInput in, CDOSessionProtocol.CommitTransactionResult result) throws IOException {
        if (in.readBoolean()) {
            int n = in.readInt();
            int i = 0;
            while (i < n) {
                CDOID id = in.readCDOID();
                CDOPermission permission = (CDOPermission)in.readEnum(CDOPermission.class);
                result.addNewPermission(id, permission);
                ++i;
            }
        }
    }
}

