/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.generatefrommodel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

class FileUtil {
    FileUtil() {
    }

    public static List<EObject> getModels(IProject iProject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        FileUtil.getModelsRecursively((IResource)iProject, result);
        return result;
    }

    private static void getModelsRecursively(IResource iResource, List<EObject> result) {
        if (!iResource.isAccessible() || iResource.isHidden() || !iResource.exists()) {
            return;
        }
        if (iResource instanceof IProject && !((IProject)iResource).isOpen()) {
            return;
        }
        if (iResource instanceof IContainer) {
            IContainer iContainer = (IContainer)iResource;
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource childResource = iResourceArray[n2];
                    FileUtil.getModelsRecursively(childResource, result);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (iResource instanceof IFile) {
            List<EObject> eObjects = FileUtil.loadResource((IFile)iResource);
            result.addAll(eObjects);
        }
    }

    private static List<EObject> loadResource(IFile file) {
        EList result = null;
        String path = file.getLocation().toString();
        XMIResourceImpl resource = new XMIResourceImpl();
        File source = new File(path);
        try {
            resource.load((InputStream)new FileInputStream(source), new HashMap());
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        result = resource.getContents();
        return result;
    }
}

