/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.sysml.blocks.ValueType;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstraintBlockPropertyEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Property element = (Property)request.getElementToConfigure();
                if (element != null) {
                    Element owner = element.getOwner();
                    if (((ISpecializationType)SysMLElementTypes.CONSTRAINT_BLOCK).getMatcher().matches((EObject)owner)) {
                        element.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand gmfCommand = super.getBeforeSetCommand(request);
        EObject elementToEdit = request.getElementToEdit();
        if (!(elementToEdit instanceof Property) || request.getFeature() != UMLPackage.eINSTANCE.getTypedElement_Type()) {
            return gmfCommand;
        }
        Property propertyToEdit = (Property)elementToEdit;
        if (!this.isBlockOrValueTypeProperty(propertyToEdit)) {
            return gmfCommand;
        }
        AggregationKind expectedAggregation = this.getExpectedAggregationKind(propertyToEdit.getType(), (Type)request.getValue(), propertyToEdit.getAggregation());
        if (expectedAggregation == null) {
            return gmfCommand;
        }
        EAttribute feature = UMLPackage.eINSTANCE.getProperty_Aggregation();
        SetRequest setRequest = new SetRequest((EObject)propertyToEdit, (EStructuralFeature)feature, (Object)expectedAggregation);
        SetValueCommand changeAggregationCommand = new SetValueCommand(setRequest);
        return CompositeCommand.compose((ICommand)gmfCommand, (ICommand)changeAggregationCommand);
    }

    private boolean isBlockOrValueTypeProperty(Property property) {
        Element owner = property.getOwner();
        return ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)owner) || ((ISpecializationType)SysMLElementTypes.VALUE_TYPE).getMatcher().matches((EObject)owner);
    }

    private boolean isValueType(Type value) {
        return value instanceof DataType && UMLUtil.getStereotypeApplication((Element)value, ValueType.class) != null;
    }

    private AggregationKind getExpectedAggregationKind(Type currentType, Type newType, AggregationKind currentAggregationKind) {
        if (this.isValueType(currentType) && !this.isValueType(newType) && AggregationKind.COMPOSITE_LITERAL == currentAggregationKind) {
            return AggregationKind.NONE_LITERAL;
        }
        if (!this.isValueType(currentType) && this.isValueType(newType)) {
            return AggregationKind.COMPOSITE_LITERAL;
        }
        return null;
    }
}

