/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;

public class ActorEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        List<IElementType> superTypes;
        IElementType type = request.getElementType();
        if (SysMLElementTypes.ASSOCIATION.equals(type)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (type != null && (superTypes = Arrays.asList(type.getAllSuperTypes())).contains(SysMLElementTypes.ASSOCIATION)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected boolean hasSuperType(IElementType elementType, IElementType typeToTest) {
        if (elementType == null || typeToTest == null) {
            return false;
        }
        if (elementType.equals(typeToTest)) {
            return true;
        }
        List<IElementType> superTypes = Arrays.asList(elementType.getAllSuperTypes());
        return superTypes.contains(typeToTest);
    }
}

