/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ClassifierEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand gmfCommand = super.getBeforeMoveCommand(request);
        List<EObject> currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
        for (Object movedObject : request.getElementsToMove().keySet()) {
            Property movedProperty;
            Association relatedAssociation;
            if (!(movedObject instanceof Property) || movedObject instanceof Port || (relatedAssociation = (movedProperty = (Property)movedObject).getAssociation()) == null || !ElementUtil.hasNature((Element)relatedAssociation, (String)"SysML_Nature") || movedProperty.eContainer() == request.getTargetContainer() && movedProperty.eContainingFeature() == request.getTargetFeature((EObject)movedProperty) || relatedAssociation == request.getTargetContainer() && (request.getTargetFeature((EObject)movedProperty) == null || UMLPackage.eINSTANCE.getAssociation_OwnedEnd() == request.getTargetFeature((EObject)movedProperty)) || this.getOppositeAssociationEnd(movedProperty).getType() == request.getTargetContainer() || currentlyRefactoredElements.contains(movedObject) || currentlyRefactoredElements.contains(relatedAssociation)) continue;
            currentlyRefactoredElements.add((EObject)movedObject);
            request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
            ICommand refactorCommand = this.getAssociationRefactoringCommand(movedProperty, relatedAssociation, request);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)refactorCommand);
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private ICommand getAssociationRefactoringCommand(Property movedProperty, Association associationToRefactor, MoveRequest request) {
        Association relatedAssociation = movedProperty.getAssociation();
        int direction = 2;
        if (movedProperty == associationToRefactor.getMemberEnds().get(0)) {
            direction = 1;
        }
        ReorientRelationshipRequest reorientRequest = new ReorientRelationshipRequest((EObject)relatedAssociation, request.getTargetContainer(), movedProperty.eContainer(), direction);
        reorientRequest.addParameters(request.getParameters());
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)relatedAssociation);
        if (provider != null) {
            return provider.getEditCommand((IEditCommandRequest)reorientRequest);
        }
        return null;
    }

    private Property getOppositeAssociationEnd(Property associationEnd) {
        Property oppositeEnd = null;
        if (associationEnd.getAssociation() != null) {
            Association association = associationEnd.getAssociation();
            HashSet ends = new HashSet();
            ends.addAll(association.getMemberEnds());
            ends.remove(associationEnd);
            oppositeEnd = ends.size() > 0 ? (Property)ends.iterator().next() : null;
        }
        return oppositeEnd;
    }
}

