/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOPackageInfoImpl
implements InternalCDOPackageInfo {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOPackageInfoImpl.class);
    private InternalCDOPackageUnit packageUnit;
    private String packageURI;
    private String parentURI;
    private EPackage ePackage;

    public InternalCDOPackageUnit getPackageUnit() {
        return this.packageUnit;
    }

    public void setPackageUnit(InternalCDOPackageUnit packageUnit) {
        this.packageUnit = packageUnit;
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public void setPackageURI(String packageURI) {
        this.packageURI = packageURI;
    }

    public String getParentURI() {
        return this.parentURI;
    }

    public void setParentURI(String parentURI) {
        this.parentURI = parentURI;
    }

    public void write(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0}", new Object[]{this});
        }
        out.writeCDOPackageURI(this.packageURI);
        out.writeCDOPackageURI(this.parentURI);
    }

    public void read(CDODataInput in) throws IOException {
        this.packageURI = in.readCDOPackageURI();
        this.parentURI = in.readCDOPackageURI();
        if (TRACER.isEnabled()) {
            TRACER.format("Read {0}", new Object[]{this});
        }
    }

    public InternalCDOPackageInfo copy() {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.setPackageURI(this.getPackageURI());
        packageInfo.setParentURI(this.getParentURI());
        packageInfo.setEPackage(this.getEPackage());
        return packageInfo;
    }

    public EFactory getEFactory() {
        return this.getEPackage().getEFactoryInstance();
    }

    public EPackage getEPackage() {
        return this.getEPackage(true);
    }

    public EPackage getEPackage(boolean loadOnDemand) {
        if (this.ePackage == null && loadOnDemand) {
            this.packageUnit.load(true);
        }
        return this.ePackage;
    }

    public void setEPackage(EPackage ePackage) {
        this.ePackage = ePackage;
    }

    public boolean isCorePackage() {
        return CDOModelUtil.isCorePackage(this.getEPackage());
    }

    public boolean isResourcePackage() {
        return CDOModelUtil.isResourcePackage(this.getEPackage());
    }

    public boolean isTypePackage() {
        return CDOModelUtil.isTypesPackage(this.getEPackage());
    }

    public boolean isSystemPackage() {
        return CDOModelUtil.isSystemPackage(this.getEPackage());
    }

    public int compareTo(CDOPackageInfo o) {
        return this.getPackageURI().compareTo(o.getPackageURI());
    }

    public String toString() {
        return MessageFormat.format("CDOPackageInfo[packageURI={0}, parentURI={1}]", this.packageURI, this.parentURI);
    }

    @Deprecated
    public void notifyChanged(Notification notification) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Notifier getTarget() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setTarget(Notifier newTarget) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void unsetTarget(Notifier oldTarget) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isAdapterForType(Object type) {
        throw new UnsupportedOperationException();
    }
}

