/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ContainerConfiguration;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.IConfiguredContainerDescriptor;
import org.eclipse.papyrus.infra.types.core.factories.IContainerFactory;
import org.eclipse.papyrus.infra.types.core.registries.MatcherConfigurationTypeRegistry;

public class ContainerConfigurationTypeRegistry {
    private static ContainerConfigurationTypeRegistry registry;
    protected Map<String, IContainerFactory<? extends ContainerConfiguration>> containerConfigurationTypeToFactory = null;

    public static synchronized ContainerConfigurationTypeRegistry getInstance() {
        if (registry == null) {
            registry = new ContainerConfigurationTypeRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.containerConfigurationTypeToFactory = new HashMap<String, IContainerFactory<? extends ContainerConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.containerConfigurationKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationClass = configurationElement.getAttribute("configurationClass");
            try {
                Object factoryClass = configurationElement.createExecutableExtension("factoryClass");
                if (factoryClass instanceof IContainerFactory) {
                    this.containerConfigurationTypeToFactory.put(configurationClass, (IContainerFactory)factoryClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    protected <T extends ContainerConfiguration> IContainerFactory<T> getFactory(ContainerConfiguration containerConfiguration) {
        String containerConfigurationType = containerConfiguration.eClass().getInstanceTypeName();
        IContainerFactory<? extends ContainerConfiguration> factory = this.containerConfigurationTypeToFactory.get(containerConfigurationType);
        return factory;
    }

    public <T extends ContainerConfiguration> IContainerDescriptor getContainerDescriptor(T containerConfiguration) {
        if (containerConfiguration == null) {
            return null;
        }
        IContainerFactory<T> factory = this.getFactory(containerConfiguration);
        IConfiguredContainerDescriptor<T> containerDescriptor = factory == null ? new DefaultContainerDescriptor(containerConfiguration) : factory.createContainerDescriptor(containerConfiguration);
        containerDescriptor.init(containerConfiguration);
        return containerDescriptor;
    }

    public class DefaultContainerDescriptor<T extends ContainerConfiguration>
    implements IConfiguredContainerDescriptor<T> {
        protected ContainerConfiguration containerConfiguration;
        protected IElementMatcher matcher;
        protected EReference[] references;

        public DefaultContainerDescriptor(ContainerConfiguration containerConfiguration) {
            AbstractMatcherConfiguration matcherConfiguration = containerConfiguration.getContainerMatcherConfiguration();
            this.matcher = MatcherConfigurationTypeRegistry.getInstance().getMatcher(matcherConfiguration);
            EList eContainmentFeatures = containerConfiguration.getEContainmentFeatures();
            this.references = (EReference[])eContainmentFeatures.toArray((Object[])new EReference[0]);
        }

        public IElementMatcher getMatcher() {
            return this.matcher;
        }

        public EReference[] getContainmentFeatures() {
            return this.references;
        }

        @Override
        public void init(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
        }
    }
}

