/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractListEditor
extends AbstractEditor {
    protected IObservableList modelProperty;
    protected UpdateListStrategy targetToModelStrategy;
    protected UpdateListStrategy modelToTargetStrategy;
    protected IObservableList widgetObservable;

    protected AbstractListEditor(Composite parent) {
        super(parent);
    }

    protected AbstractListEditor(Composite parent, int style, String label) {
        super(parent, style, label);
    }

    protected AbstractListEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected AbstractListEditor(Composite parent, String label) {
        super(parent, label);
    }

    protected void setWidgetObservable(IObservableList widgetObservable, IConverter targetToModel, IConverter modelToTarget) {
        this.widgetObservable = widgetObservable;
        this.setConverters(targetToModel, modelToTarget);
    }

    protected void setWidgetObservable(IObservableList widgetObservable) {
        this.widgetObservable = widgetObservable;
    }

    public void setModelObservable(IObservableList modelProperty) {
        this.modelProperty = modelProperty;
        this.doBinding();
    }

    @Override
    public void setConverters(IConverter targetToModel, IConverter modelToTarget) {
        if (this.targetToModelStrategy == null) {
            this.targetToModelStrategy = new UpdateListStrategy();
        }
        if (this.modelToTargetStrategy == null) {
            this.modelToTargetStrategy = new UpdateListStrategy();
        }
        this.targetToModelStrategy.setConverter(targetToModel);
        this.modelToTargetStrategy.setConverter(modelToTarget);
    }

    public void setUpdateStrategies(UpdateListStrategy targetToModelStrategy, UpdateListStrategy modelToTargetStrategy) {
        this.targetToModelStrategy = targetToModelStrategy;
        this.modelToTargetStrategy = modelToTargetStrategy;
    }

    @Override
    protected void doBinding() {
        if (this.modelProperty == null || this.widgetObservable == null) {
            return;
        }
        this.binding = this.getBindingContext().bindList(this.widgetObservable, this.modelProperty, this.targetToModelStrategy, this.modelToTargetStrategy);
    }

    @Override
    protected Object getContextElement() {
        return this.modelProperty instanceof IObserving ? ((IObserving)this.modelProperty).getObserved() : null;
    }
}

