/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractShowHideParameterPropertyEditPolicy
extends AbstractEditPolicy
implements NotificationListener {
    protected ActivityParameterNode semanticElement;
    protected Parameter currentParameter;

    public void activate() {
        super.activate();
        this.startListen();
    }

    public void deactivate() {
        this.stopListen();
        super.deactivate();
    }

    protected void startListen() {
        this.semanticElement = this.findHostSemantic();
        this.addEObjectListener(this.semanticElement);
        this.currentParameter = this.semanticElement.getParameter();
        this.addEObjectListener(this.currentParameter);
        this.refresh();
    }

    public abstract void refresh();

    protected void stopListen() {
        this.removeEObjectListener(this.semanticElement);
        this.removeEObjectListener(this.currentParameter);
    }

    protected void addEObjectListener(Object object) {
        if (object instanceof EObject) {
            this.getDiagramEventBroker().addNotificationListener((EObject)object, (NotificationListener)this);
        }
    }

    protected void removeEObjectListener(Object object) {
        if (object instanceof EObject) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)object, (NotificationListener)this);
        }
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    protected ActivityParameterNode findHostSemantic() {
        return (ActivityParameterNode)this.getHost().resolveSemanticElement();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain editingDomain = this.getHost().getEditingDomain();
        if (editingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == this.semanticElement) {
            this.notifyActivityParameterNode(notification);
        } else if (object != null && object == this.currentParameter) {
            this.notifyParameter(notification);
        }
    }

    protected abstract void notifyParameter(Notification var1);

    protected void notifyActivityParameterNode(Notification notification) {
        switch (notification.getFeatureID(ActivityParameterNode.class)) {
            case 27: {
                switch (notification.getEventType()) {
                    case 1: {
                        this.removeEObjectListener(notification.getOldValue());
                        this.addEObjectListener(notification.getNewValue());
                        if (notification.getFeature() != UMLPackage.Literals.ACTIVITY_PARAMETER_NODE__PARAMETER) break;
                        this.currentParameter = (Parameter)notification.getNewValue();
                        break;
                    }
                    case 2: {
                        this.removeEObjectListener(notification.getOldValue());
                        if (notification.getFeature() != UMLPackage.Literals.ACTIVITY_PARAMETER_NODE__PARAMETER) break;
                        this.currentParameter = null;
                    }
                }
                this.refresh();
            }
        }
    }

    protected void execute(TransactionalEditingDomain domain, SetValueCommand setVisibleCommand) {
        try {
            GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)setVisibleCommand);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void hideLabelView(View view) {
        if (view.isVisible()) {
            SetValueCommand setVisibleCommand = new SetValueCommand(new SetRequest((EObject)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), (Object)Boolean.FALSE));
            this.execute(this.getHost().getEditingDomain(), setVisibleCommand);
        }
    }

    protected void showLabelView(View view) {
        if (!view.isVisible()) {
            SetValueCommand setVisibleCommand = new SetValueCommand(new SetRequest((EObject)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), (Object)Boolean.TRUE));
            this.execute(this.getHost().getEditingDomain(), setVisibleCommand);
        }
    }

    protected View getLabelView(String VID) {
        View labelView = null;
        for (Object child : this.getHost().getNotationView().getChildren()) {
            View view = (View)child;
            if (!view.getType().equals(VID)) continue;
            labelView = view;
            break;
        }
        assert (labelView == null) : "Child view should be always present in host view";
        return labelView;
    }
}

