/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.edition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NameSimplifier;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.nattable.provider.UMLFeatureRestrictedContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TreeFillingConfigurationDialog
extends SelectionDialog {
    protected static final List<String> possibleAxisCreation = new ArrayList<String>();
    protected final TreeFillingConfiguration modifiedTreefillingConfiguration;
    protected final List<ILabelProviderConfiguration> existingLabelProviderConfigurations;
    protected final List<PasteEObjectConfiguration> existingPasteConfigurations;
    protected final ILabelProvider labelProvider = new UMLLabelProvider();
    protected StackLayout stackLayout;
    protected Composite compositeElement;
    protected Composite compositeElementReference;
    protected Composite compositeElementString;
    protected CLabel elementCLabel;
    protected Text elementText;
    protected Button browseValuesButton;
    protected Button deleteValuesButton;

    static {
        possibleAxisCreation.add("EObjectAxis");
        possibleAxisCreation.add("EOperationAxis");
        possibleAxisCreation.add("EStructuralFeatureAxis");
        possibleAxisCreation.add("FeatureIdAxis");
        possibleAxisCreation.add("ObjectAxis");
    }

    public TreeFillingConfigurationDialog(Shell parentShell, TreeFillingConfiguration treefillingConfiguration, List<ILabelProviderConfiguration> existingLabelProvidersConfiguration, List<PasteEObjectConfiguration> existingPasteConfigurations) {
        super(parentShell);
        this.modifiedTreefillingConfiguration = (TreeFillingConfiguration)EcoreUtil.copy((EObject)treefillingConfiguration);
        this.existingLabelProviderConfigurations = existingLabelProvidersConfiguration;
        this.existingPasteConfigurations = existingPasteConfigurations;
        this.setTitle(Messages.TreeFillingConfigurationDialog_treeFillingConfigurationDialogName);
    }

    public void create() {
        super.create();
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        Composite parent = new Composite((Composite)this.getDialogArea(), 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getShell().setSize(600, 400);
        this.createFields(parent);
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int minWidth = 600;
        if (size.x < minWidth) {
            size.x = minWidth;
        }
        this.getShell().setSize(size);
    }

    protected void createFields(Composite parent) {
        this.createDepthLevelCombo(parent);
        this.createLabelProviderCombo(parent);
        this.createPasteConfigurationCombo(parent);
        this.createAxisGroup(parent);
        this.setAxisUsedAsAxisProvider(this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider());
        if (this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider() != null) {
            this.setAxisElement(this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider().getElement());
        }
    }

    protected void createDepthLevelCombo(Composite parent) {
        Label depthLabel = new Label(parent, 0);
        depthLabel.setText(Messages.TreeFillingConfigurationDialog_depthLabel);
        depthLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Combo depthCombo = new Combo(parent, 8);
        depthCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        depthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.setDepth(Integer.valueOf(depthCombo.getText()).intValue());
            }
        });
        ArrayList<String> possiblesDepth = new ArrayList<String>(10);
        int i = 0;
        while (i < 10) {
            possiblesDepth.add(String.valueOf(i));
            ++i;
        }
        depthCombo.setItems(possiblesDepth.toArray(new String[possiblesDepth.size()]));
        depthCombo.select(this.modifiedTreefillingConfiguration.getDepth());
    }

    protected void createLabelProviderCombo(Composite parent) {
        Label labelProviderConfigurationLabel = new Label(parent, 0);
        labelProviderConfigurationLabel.setText(Messages.TreeFillingConfigurationDialog_labelProviderLabel);
        labelProviderConfigurationLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Combo labelProviderConfigurationCombo = new Combo(parent, 8);
        labelProviderConfigurationCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        labelProviderConfigurationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (labelProviderConfigurationCombo.getText().isEmpty()) {
                    TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.setLabelProvider(null);
                } else {
                    TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.setLabelProvider(TreeFillingConfigurationDialog.this.existingLabelProviderConfigurations.get(labelProviderConfigurationCombo.getSelectionIndex() - 1));
                }
            }
        });
        ArrayList<String> labelProviders = new ArrayList<String>(this.existingLabelProviderConfigurations.size());
        for (ILabelProviderConfiguration existingLabelProviderConf : this.existingLabelProviderConfigurations) {
            String shortLabelProviderName;
            String className = existingLabelProviderConf.getClass().getSimpleName();
            if (!NameSimplifier.labelProviderConfigurationNames.containsKey(className)) continue;
            String finalShortLabelProviderName = shortLabelProviderName = NameSimplifier.labelProviderConfigurationNames.get(className);
            int index = 1;
            while (labelProviders.contains(finalShortLabelProviderName)) {
                StringBuilder builder = new StringBuilder();
                builder.append(shortLabelProviderName);
                builder.append("_");
                builder.append(index);
                finalShortLabelProviderName = builder.toString();
                ++index;
            }
            labelProviders.add(finalShortLabelProviderName);
        }
        labelProviderConfigurationCombo.setItems(labelProviders.toArray(new String[labelProviders.size()]));
        if (this.modifiedTreefillingConfiguration.getLabelProvider() != null) {
            int index = this.existingLabelProviderConfigurations.indexOf(this.modifiedTreefillingConfiguration.getLabelProvider());
            labelProviderConfigurationCombo.select(index);
        }
    }

    protected void createPasteConfigurationCombo(Composite parent) {
        Label pasteConfigurationLabel = new Label(parent, 0);
        pasteConfigurationLabel.setText(Messages.TreeFillingConfigurationDialog_pasteConfigurationLabel);
        pasteConfigurationLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Combo pasteConfigurationCombo = new Combo(parent, 8);
        pasteConfigurationCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        pasteConfigurationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (pasteConfigurationCombo.getText().isEmpty()) {
                    TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.setPasteConfiguration(null);
                } else {
                    TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.setPasteConfiguration(TreeFillingConfigurationDialog.this.existingPasteConfigurations.get(pasteConfigurationCombo.getSelectionIndex() - 1));
                }
            }
        });
        ArrayList<String> pasteConfigurations = new ArrayList<String>(this.existingPasteConfigurations.size());
        pasteConfigurations.add("");
        for (PasteEObjectConfiguration existingPasteConf : this.existingPasteConfigurations) {
            StringBuilder builder = new StringBuilder();
            builder.append("Paste Conf: '");
            builder.append(existingPasteConf.getPastedElementId());
            builder.append("' in '");
            builder.append(existingPasteConf.getPasteElementContainementFeature().getName());
            builder.append("'");
            pasteConfigurations.add(builder.toString());
        }
        pasteConfigurationCombo.setItems(pasteConfigurations.toArray(new String[pasteConfigurations.size()]));
        if (this.modifiedTreefillingConfiguration.getPasteConfiguration() != null) {
            int index = this.existingPasteConfigurations.indexOf(this.modifiedTreefillingConfiguration.getPasteConfiguration());
            pasteConfigurationCombo.select(index);
        }
    }

    protected void createAxisGroup(Composite parent) {
        Group axisGroup = new Group(parent, 0);
        axisGroup.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        axisGroup.setLayout((Layout)new GridLayout(4, false));
        axisGroup.setText(Messages.TreeFillingConfigurationDialog_axisUsedAsAxisProviderLabel);
        Label axisTypeLabel = new Label((Composite)axisGroup, 0);
        axisTypeLabel.setText(Messages.TreeFillingConfigurationDialog_typeLabel);
        axisTypeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final Combo axisTypeCombo = new Combo((Composite)axisGroup, 8);
        axisTypeCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        axisTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAxis existingAxis = TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider();
                if (axisTypeCombo.getText().isEmpty() && existingAxis != null) {
                    TreeFillingConfigurationDialog.this.setAxisUsedAsAxisProvider(null);
                } else if (existingAxis == null || !existingAxis.getClass().getSimpleName().substring(0, existingAxis.getClass().getSimpleName().length() - 4).equals(axisTypeCombo.getText())) {
                    EObjectAxis recreatedAxis = null;
                    if ("EObjectAxis".equals(axisTypeCombo.getText())) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEObjectAxis();
                    } else if ("EOperationAxis".equals(axisTypeCombo.getText())) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEOperationAxis();
                    } else if ("EStructuralFeatureAxis".equals(axisTypeCombo.getText())) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
                    } else if ("FeatureIdAxis".equals(axisTypeCombo.getText())) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
                    } else if ("ObjectAxis".equals(axisTypeCombo.getText())) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createObjectIdAxis();
                    }
                    if (existingAxis != null) {
                        recreatedAxis.setAlias(existingAxis.getAlias());
                    }
                    TreeFillingConfigurationDialog.this.setAxisUsedAsAxisProvider((IAxis)recreatedAxis);
                }
            }
        });
        ArrayList<String> possiblesAxis = new ArrayList<String>(possibleAxisCreation);
        possiblesAxis.add(0, "");
        axisTypeCombo.setItems(possiblesAxis.toArray(new String[possiblesAxis.size()]));
        boolean foundAxis = false;
        if (this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider() != null) {
            IAxis existingAxis = this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider();
            String existingAxisClassName = existingAxis.getClass().getSimpleName().substring(0, existingAxis.getClass().getSimpleName().length() - 4);
            int index = 0;
            while (index < possiblesAxis.size() && !foundAxis) {
                String axisClass = (String)possiblesAxis.get(index);
                if (existingAxisClassName.equals(axisClass)) {
                    axisTypeCombo.select(index);
                    foundAxis = true;
                }
                ++index;
            }
        } else {
            axisTypeCombo.select(0);
        }
        this.stackLayout = new StackLayout();
        this.compositeElement = new Composite((Composite)axisGroup, 0);
        this.compositeElement.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.compositeElement.setLayout((Layout)this.stackLayout);
        this.compositeElementReference = new Composite(this.compositeElement, 0);
        this.compositeElementReference.setLayout((Layout)new GridLayout(4, false));
        Label elementLabel = new Label(this.compositeElementReference, 0);
        elementLabel.setText(Messages.TreeFillingConfigurationDialog_elementLabel);
        elementLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementCLabel = new CLabel(this.compositeElementReference, 2048);
        this.elementCLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.browseValuesButton = new Button(this.compositeElementReference, 8);
        this.browseValuesButton.setImage(Activator.getDefault().getImage("/icons/browse_12x12.gif"));
        this.browseValuesButton.setToolTipText(org.eclipse.papyrus.infra.widgets.messages.Messages.ReferenceDialog_EditValue);
        this.browseValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject element = null;
                IAxis existingAxis = TreeFillingConfigurationDialog.this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider();
                if (existingAxis instanceof EObjectAxis) {
                    element = ((EObjectAxis)existingAxis).getElement();
                } else if (existingAxis instanceof EStructuralFeatureAxis) {
                    element = ((EStructuralFeatureAxis)existingAxis).getElement();
                } else if (existingAxis instanceof EOperationAxis) {
                    element = ((EOperationAxis)existingAxis).getElement();
                }
                TreeFillingConfigurationDialog.this.browseAction(element);
            }
        });
        this.deleteValuesButton = new Button(this.compositeElementReference, 8);
        this.deleteValuesButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.deleteValuesButton.setToolTipText(org.eclipse.papyrus.infra.widgets.messages.Messages.ReferenceDialog_UnsetValue);
        this.deleteValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFillingConfigurationDialog.this.setAxisElement(null);
            }
        });
        this.compositeElementString = new Composite(this.compositeElement, 0);
        this.compositeElementString.setLayout((Layout)new GridLayout(4, false));
        Label secondElementLabel = new Label(this.compositeElementString, 0);
        secondElementLabel.setText(Messages.TreeFillingConfigurationDialog_elementLabel);
        secondElementLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementText = new Text(this.compositeElementString, 2048);
        this.elementText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.elementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeFillingConfigurationDialog.this.setAxisElement(TreeFillingConfigurationDialog.this.elementText.getText());
            }
        });
    }

    protected void browseAction(Object value) {
        int result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell()){

            protected void initViewerAndProvider() {
                super.initViewerAndProvider();
                this.getViewer().setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        dialog.setTitle(Messages.TreeFillingConfigurationDialog_elementDialogName);
        UMLFeatureRestrictedContentProvider contentProvider = new UMLFeatureRestrictedContentProvider(null, false){

            public Object[] getChildren(Object parentElement) {
                List<Object> childrenList = Arrays.asList(super.getChildren(parentElement));
                if (parentElement instanceof EClass) {
                    childrenList = new ArrayList<Object>(childrenList);
                    EClass eClass = (EClass)parentElement;
                    if (this.isIgnoringInheritedElements()) {
                        childrenList.addAll((Collection<Object>)eClass.getEOperations());
                    } else {
                        childrenList.addAll((Collection<Object>)eClass.getEAllOperations());
                    }
                    childrenList.remove(EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
                }
                return childrenList.toArray();
            }
        };
        ReferenceSelector selector = new ReferenceSelector(false){

            public void createControls(Composite parent) {
                super.createControls(parent);
                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        selector.setLabelProvider(this.labelProvider);
        selector.setContentProvider((IStaticContentProvider)contentProvider);
        FlattenableRestrictedFilteredContentProvider treeContentProvider = new FlattenableRestrictedFilteredContentProvider((IRestrictedContentProvider)contentProvider, selector){

            public boolean isValidValue(Object element) {
                return TreeFillingConfigurationDialog.this.isTypeNeeded(element);
            }
        };
        dialog.setContentProvider((ITreeContentProvider)treeContentProvider);
        dialog.setLabelProvider(this.labelProvider);
        if (value != null) {
            dialog.setInitialElementSelections(Collections.singletonList(value));
        }
        if ((result = dialog.open()) == 0) {
            Object[] newValue = dialog.getResult();
            if (newValue == null) {
                return;
            }
            if (newValue.length == 0) {
                this.setAxisElement(null);
            } else {
                this.setAxisElement(newValue[0]);
            }
        }
    }

    protected boolean isTypeNeeded(Object element) {
        boolean result = false;
        IAxis existingAxis = this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider();
        if (existingAxis != null) {
            boolean bl = result = element != EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
            if (existingAxis instanceof EObjectAxis && result) {
                result = element instanceof EClass;
            } else if (existingAxis instanceof EStructuralFeatureAxis && result) {
                result = element instanceof EStructuralFeature;
            } else if (existingAxis instanceof EOperationAxis && result) {
                result = element instanceof EOperation;
            }
        }
        return result;
    }

    protected void setAxisUsedAsAxisProvider(IAxis newAxis) {
        if (this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider() == null || !this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider().equals(newAxis)) {
            this.modifiedTreefillingConfiguration.setAxisUsedAsAxisProvider(newAxis);
        }
        this.stackLayout.topControl = newAxis instanceof FeatureIdAxis ? this.compositeElementString : this.compositeElementReference;
        this.compositeElement.layout();
        if (this.stackLayout.topControl.equals(this.compositeElementString)) {
            this.elementText.setText(newAxis != null && newAxis.getElement() != null ? ((FeatureIdAxis)newAxis).getElement() : "");
        }
        this.setAxisElement(newAxis != null ? newAxis.getElement() : null);
    }

    protected void setAxisElement(Object element) {
        IAxis existingAxis = this.modifiedTreefillingConfiguration.getAxisUsedAsAxisProvider();
        if (existingAxis != null) {
            if (existingAxis instanceof EObjectAxis && (element == null || element instanceof EObject)) {
                ((EObjectAxis)existingAxis).setElement((EObject)element);
            } else if (existingAxis instanceof EStructuralFeatureAxis && (element == null || element instanceof EStructuralFeature)) {
                ((EStructuralFeatureAxis)existingAxis).setElement((EStructuralFeature)element);
            } else if (existingAxis instanceof EOperationAxis && (element == null || element instanceof EOperation)) {
                ((EOperationAxis)existingAxis).setElement((EOperation)element);
            } else if (existingAxis instanceof FeatureIdAxis && (element == null || element instanceof String)) {
                ((FeatureIdAxis)existingAxis).setElement((String)element);
            }
        }
        if (this.stackLayout.topControl.equals(this.compositeElementReference)) {
            this.elementCLabel.setEnabled(existingAxis != null);
            this.elementCLabel.setImage(this.labelProvider.getImage(element));
            this.elementCLabel.setText(this.labelProvider.getText(element));
            this.browseValuesButton.setEnabled(existingAxis != null);
            this.deleteValuesButton.setEnabled(existingAxis != null && element != null);
        }
    }

    public TreeFillingConfiguration getModifiedTreeFillingConfiguration() {
        return this.modifiedTreefillingConfiguration;
    }
}

