/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.customization.nattableconfiguration.helper.TableConfigurationHelper;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.AbstractTableConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NattableConfigurationEditingSupport;
import org.eclipse.papyrus.infra.nattable.comparator.IntegerFilterComparator;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EOperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ObjectIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.SlaveObjectAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.nattable.provider.UMLFeatureRestrictedContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SlaveConfigurationWizardPage
extends AbstractTableConfigurationWizardPage {
    protected final TableConfiguration configuration;
    protected final ILabelProvider labelProvider = new UMLLabelProvider();
    protected Button addAxis;
    protected Button removeAxis;
    protected Button upAxis;
    protected Button downAxis;

    public SlaveConfigurationWizardPage(TableConfigurationHelper helper) {
        super(Messages.SlaveConfigurationWizardPage_pageName, helper);
        this.configuration = helper.getTableConfiguration();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayout((Layout)new GridLayout(2, false));
        final SlaveObjectAxisProvider slave = this.getOrCreateSlaveObjectAxisProvider(this.configuration);
        final TableViewer tableViewer = this.createTableViewer(container, slave);
        Composite buttonsComposite = new Composite(container, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addAxis = new Button(buttonsComposite, 8);
        this.addAxis.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.addAxis.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.addAxis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int lastPosition = slave.getAxis().size();
                if (!tableViewer.getStructuredSelection().isEmpty()) {
                    for (Object selectedObject : tableViewer.getStructuredSelection()) {
                        int objectPosition = slave.getAxis().indexOf(selectedObject);
                        if (objectPosition <= lastPosition) continue;
                        lastPosition = objectPosition;
                    }
                }
                EStructuralFeatureAxis createdAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
                if (lastPosition + 1 < slave.getAxis().size()) {
                    SlaveConfigurationWizardPage.this.getSlaveObjectAxisProvider(SlaveConfigurationWizardPage.this.configuration).getAxis().add(lastPosition + 1, (Object)createdAxis);
                } else {
                    SlaveConfigurationWizardPage.this.getSlaveObjectAxisProvider(SlaveConfigurationWizardPage.this.configuration).getAxis().add((Object)createdAxis);
                }
                SlaveConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)tableViewer.getStructuredSelection(), slave);
                tableViewer.refresh();
            }
        });
        this.removeAxis = new Button(buttonsComposite, 8);
        this.removeAxis.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.removeAxis.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.removeAxis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selectedObjects = tableViewer.getStructuredSelection().iterator();
                while (selectedObjects.hasNext()) {
                    slave.getAxis().remove(selectedObjects.next());
                }
                SlaveConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)tableViewer.getStructuredSelection(), slave);
                tableViewer.refresh();
            }
        });
        this.upAxis = new Button(buttonsComposite, 128);
        this.upAxis.setImage(Activator.getDefault().getImage("/icons/Up_12x12.gif"));
        this.upAxis.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.upAxis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Integer> indexToMove = new ArrayList<Integer>();
                for (IAxis selectedAxis : tableViewer.getStructuredSelection()) {
                    indexToMove.add(slave.getAxis().indexOf((Object)selectedAxis));
                }
                indexToMove.sort((Comparator<Integer>)IntegerFilterComparator.getInstance());
                for (Integer index : indexToMove) {
                    slave.getAxis().move(index - 1, index.intValue());
                }
                SlaveConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)tableViewer.getStructuredSelection(), slave);
                tableViewer.refresh();
            }
        });
        this.downAxis = new Button(buttonsComposite, 1024);
        this.downAxis.setImage(Activator.getDefault().getImage("/icons/Down_12x12.gif"));
        this.downAxis.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.downAxis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Integer> indexToMove = new ArrayList<Integer>();
                for (IAxis selectedAxis : tableViewer.getStructuredSelection()) {
                    indexToMove.add(slave.getAxis().indexOf((Object)selectedAxis));
                }
                indexToMove.sort((Comparator<Integer>)IntegerFilterComparator.getInstance());
                int it = indexToMove.size() - 1;
                while (it >= 0) {
                    int index = (Integer)indexToMove.get(it);
                    slave.getAxis().move(index + 1, index);
                    --it;
                }
                SlaveConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)tableViewer.getStructuredSelection(), slave);
                tableViewer.refresh();
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SlaveConfigurationWizardPage.this.recalculateButtonsAvailability(event.getSelection(), slave);
            }
        });
        tableViewer.setSelection((ISelection)new StructuredSelection());
        this.setControl((Control)container);
    }

    protected void recalculateButtonsAvailability(ISelection selection, SlaveObjectAxisProvider slave) {
        if (selection != null && !selection.isEmpty()) {
            this.removeAxis.setEnabled(true);
            int firstPosition = -1;
            int lastPosition = -1;
            if (selection instanceof StructuredSelection) {
                for (Object selectedObject : (StructuredSelection)selection) {
                    int objectPosition = slave.getAxis().indexOf(selectedObject);
                    if (-1 == firstPosition || objectPosition < firstPosition) {
                        firstPosition = objectPosition;
                    }
                    if (objectPosition <= lastPosition) continue;
                    lastPosition = objectPosition;
                }
            }
            this.upAxis.setEnabled(firstPosition != 0);
            this.downAxis.setEnabled(lastPosition < slave.getAxis().size() - 1);
        } else {
            this.removeAxis.setEnabled(false);
            this.upAxis.setEnabled(false);
            this.downAxis.setEnabled(false);
        }
    }

    protected TableViewer createTableViewer(Composite parent, SlaveObjectAxisProvider slave) {
        TableViewer tableViewer = new TableViewer(parent, 68354);
        this.createColumns(tableViewer);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setInput((Object)slave.getAxis());
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.refresh();
        return tableViewer;
    }

    protected void createColumns(final TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        int[] bounds = new int[]{150, 250, 450, 100};
        String[] titles = new String[]{Messages.SlaveConfigurationWizardPage_typeColumnName, Messages.SlaveConfigurationWizardPage_elementColumnName, Messages.SlaveConfigurationWizardPage_managerColumnName, Messages.SlaveConfigurationWizardPage_aliasColumnName};
        final ArrayList<String> typesPossible = new ArrayList<String>();
        typesPossible.add("EObjectAxis");
        typesPossible.add("EOperationAxis");
        typesPossible.add("EStructuralFeatureAxis");
        typesPossible.add("FeatureIdAxis");
        typesPossible.add("ObjectAxis");
        TableViewerColumn firstColumn = this.createTableViewerColumn(tableViewer, titles[0], bounds[0]);
        ColumnLabelProvider typeLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAxis)element).getClass().getSimpleName().substring(0, ((IAxis)element).getClass().getSimpleName().length() - 4);
            }
        };
        firstColumn.setLabelProvider((CellLabelProvider)typeLabelProvider);
        firstColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)typeLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                IAxis axis = (IAxis)element;
                if (element == null || !((IAxis)element).getClass().getSimpleName().substring(0, ((IAxis)element).getClass().getSimpleName().length() - 4).equals(value) && !value.toString().isEmpty()) {
                    EObjectAxis recreatedAxis = null;
                    if ("EObjectAxis".equals(value)) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEObjectAxis();
                    } else if ("EOperationAxis".equals(value)) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEOperationAxis();
                    } else if ("EStructuralFeatureAxis".equals(value)) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
                    } else if ("FeatureIdAxis".equals(value)) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
                    } else if ("ObjectAxis".equals(value)) {
                        recreatedAxis = NattableaxisFactory.eINSTANCE.createObjectIdAxis();
                    }
                    recreatedAxis.setAlias(axis.getAlias());
                    recreatedAxis.setManager(axis.getManager());
                    SlaveObjectAxisProvider slave = SlaveConfigurationWizardPage.this.getSlaveObjectAxisProvider(SlaveConfigurationWizardPage.this.configuration);
                    int indexAxisInParent = slave.getAxis().indexOf((Object)axis);
                    slave.getAxis().add(indexAxisInParent, (Object)recreatedAxis);
                    slave.getAxis().remove((Object)axis);
                    tableViewer.refresh();
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)table, typesPossible, (ILabelProvider)new LabelProvider(), 8);
            }
        });
        TableViewerColumn secondColumn = this.createTableViewerColumn(tableViewer, titles[1], bounds[1]);
        ColumnLabelProvider elementLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                IAxis axis;
                String result = null;
                if (element instanceof IAxis && (axis = (IAxis)element).getElement() != null) {
                    result = SlaveConfigurationWizardPage.this.labelProvider.getText(axis.getElement());
                }
                return result != null ? result : null;
            }

            public Image getImage(Object element) {
                IAxis axis;
                Image result = null;
                if (element instanceof IAxis && (axis = (IAxis)element).getElement() != null) {
                    result = SlaveConfigurationWizardPage.this.labelProvider.getImage(axis.getElement());
                }
                return result != null ? result : null;
            }
        };
        secondColumn.setLabelProvider((CellLabelProvider)elementLabelProvider);
        secondColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, this.labelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                IAxis axis = (IAxis)element;
                if (axis.getElement() == null || !axis.getElement().equals(value)) {
                    if (axis instanceof EObjectAxis && value instanceof EObject) {
                        ((EObjectAxis)axis).setElement((EObject)value);
                    } else if (axis instanceof EOperationAxis && value instanceof EOperation) {
                        ((EOperationAxis)axis).setElement((EOperation)value);
                    } else if (axis instanceof EStructuralFeatureAxis && value instanceof EStructuralFeature) {
                        ((EStructuralFeatureAxis)axis).setElement((EStructuralFeature)value);
                    } else if (axis instanceof FeatureIdAxis && value instanceof String) {
                        ((FeatureIdAxis)axis).setElement((String)value);
                    } else if (axis instanceof ObjectIdAxis && value instanceof String) {
                        ((ObjectIdAxis)axis).setElement((String)value);
                    }
                    tableViewer.refresh();
                }
            }

            @Override
            protected Object getValue(Object element) {
                IAxis axis;
                String result = null;
                if (element instanceof IAxis && (axis = (IAxis)element).getElement() != null) {
                    result = this.labelProvider.getText(axis.getElement());
                }
                return result != null ? result : "";
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                if (element instanceof IdAxis) {
                    return new TextCellEditor((Composite)table);
                }
                final IAxis existingAxis = (IAxis)element;
                final Object initialValue = this.getValue(element);
                return new DialogCellEditor((Composite)table){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        TreeSelectorDialog dialog = new TreeSelectorDialog(SlaveConfigurationWizardPage.this.getShell()){

                            protected void initViewerAndProvider() {
                                super.initViewerAndProvider();
                                this.getViewer().setComparator(new ViewerComparator((Comparator)new StringComparator()));
                            }
                        };
                        dialog.setTitle(Messages.FeatureFillingConfigurationDialog_listenFeatureDialogName);
                        UMLFeatureRestrictedContentProvider contentProvider = new UMLFeatureRestrictedContentProvider(null, false){

                            public Object[] getChildren(Object parentElement) {
                                List<Object> childrenList = Arrays.asList(super.getChildren(parentElement));
                                if (parentElement instanceof EClass) {
                                    childrenList = new ArrayList<Object>(childrenList);
                                    EClass eClass = (EClass)parentElement;
                                    if (this.isIgnoringInheritedElements()) {
                                        childrenList.addAll((Collection<Object>)eClass.getEOperations());
                                    } else {
                                        childrenList.addAll((Collection<Object>)eClass.getEAllOperations());
                                    }
                                    childrenList.remove(EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
                                }
                                return childrenList.toArray();
                            }
                        };
                        ReferenceSelector selector = new ReferenceSelector(false){

                            public void createControls(Composite parent) {
                                super.createControls(parent);
                                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
                            }
                        };
                        selector.setLabelProvider(labelProvider);
                        selector.setContentProvider((IStaticContentProvider)contentProvider);
                        FlattenableRestrictedFilteredContentProvider treeContentProvider = new FlattenableRestrictedFilteredContentProvider((IRestrictedContentProvider)contentProvider, selector){

                            public boolean isValidValue(Object element) {
                                boolean result = false;
                                if (existingAxis != null) {
                                    boolean bl = result = element != EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
                                    if (existingAxis instanceof EObjectAxis && result) {
                                        result = element instanceof EClass;
                                    } else if (existingAxis instanceof EStructuralFeatureAxis && result) {
                                        result = element instanceof EStructuralFeature;
                                    } else if (existingAxis instanceof EOperationAxis && result) {
                                        result = element instanceof EOperation;
                                    }
                                }
                                return result;
                            }
                        };
                        dialog.setContentProvider((ITreeContentProvider)treeContentProvider);
                        dialog.setLabelProvider(labelProvider);
                        if (initialValue != null) {
                            dialog.setInitialElementSelections(Collections.singletonList(initialValue));
                        }
                        Object value = null;
                        int result = dialog.open();
                        if (result == 0) {
                            Object[] newValue = dialog.getResult();
                            if (newValue != null) {
                                value = newValue.length == 0 ? null : newValue[0];
                            }
                            this.setValue(value);
                        }
                        return value;
                    }
                };
            }
        });
        TableViewerColumn thirdColumn = this.createTableViewerColumn(tableViewer, titles[2], bounds[2]);
        ColumnLabelProvider managerLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAxis)element).getManager() != null ? ((IAxis)element).getManager().getAxisManagerId() : "";
            }
        };
        thirdColumn.setLabelProvider((CellLabelProvider)managerLabelProvider);
        thirdColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)managerLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                IAxis axis = (IAxis)element;
                if (value != null && !value.equals(axis.getManager())) {
                    axis.setManager((AxisManagerRepresentation)value);
                    tableViewer.refresh();
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)table, (List)SlaveConfigurationWizardPage.this.configuration.getColumnHeaderAxisConfiguration().getAxisManagers(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((AxisManagerRepresentation)element).getAxisManagerId();
                    }
                }, 8);
            }
        });
        TableViewerColumn fourthColumn = this.createTableViewerColumn(tableViewer, titles[3], bounds[3]);
        ColumnLabelProvider aliasLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAxis)element).getAlias() != null ? ((IAxis)element).getAlias() : "";
            }
        };
        fourthColumn.setLabelProvider((CellLabelProvider)aliasLabelProvider);
        fourthColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)aliasLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                IAxis axis = (IAxis)element;
                if (!value.toString().isEmpty() && !value.equals(axis.getAlias())) {
                    axis.setAlias((String)value);
                    tableViewer.refresh();
                }
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)table);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected SlaveObjectAxisProvider getSlaveObjectAxisProvider(TableConfiguration configuration) {
        SlaveObjectAxisProvider slave = null;
        if (configuration.getColumnAxisProviders().size() > 0) {
            Iterator columnAxisProvidersIterator = configuration.getColumnAxisProviders().iterator();
            while (columnAxisProvidersIterator.hasNext() && slave == null) {
                AbstractAxisProvider axisProvider = (AbstractAxisProvider)columnAxisProvidersIterator.next();
                if (!(axisProvider instanceof SlaveObjectAxisProvider)) continue;
                slave = (SlaveObjectAxisProvider)axisProvider;
            }
        }
        return slave;
    }

    protected SlaveObjectAxisProvider getOrCreateSlaveObjectAxisProvider(TableConfiguration configuration) {
        SlaveObjectAxisProvider slave = this.getSlaveObjectAxisProvider(configuration);
        if (slave == null) {
            slave = NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider();
            configuration.getColumnAxisProviders().add((Object)slave);
        }
        if (configuration.getDefaultColumnAxisProvider() == null) {
            configuration.setDefaultColumnAxisProvider((AbstractAxisProvider)slave);
        }
        return slave;
    }
}

