/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.general.general;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChangeEffectKind implements Enumerator
{
    NONE(0, "None", "None"),
    REVOKE(1, "Revoke", "Revoke"),
    MODIFY(2, "Modify", "Modify"),
    VALIDATE(3, "Validate", "Validate");

    public static final int NONE_VALUE = 0;
    public static final int REVOKE_VALUE = 1;
    public static final int MODIFY_VALUE = 2;
    public static final int VALIDATE_VALUE = 3;
    private static final ChangeEffectKind[] VALUES_ARRAY;
    public static final List<ChangeEffectKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChangeEffectKind[]{NONE, REVOKE, MODIFY, VALIDATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChangeEffectKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeEffectKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeEffectKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeEffectKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeEffectKind get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return REVOKE;
            }
            case 2: {
                return MODIFY;
            }
            case 3: {
                return VALIDATE;
            }
        }
        return null;
    }

    private ChangeEffectKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

