/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.utils.OneTimeRegistryReader;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerMonitorRegistry {
    private static final String EXT_POINT = "markerproviders";
    private final List<IMarkerMonitor> monitors = new ArrayList<IMarkerMonitor>();

    public MarkerMonitorRegistry() {
        new MyRegistryReader().readRegistry();
    }

    public List<IMarkerMonitor> getMarkerMonitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    private class MyRegistryReader
    extends OneTimeRegistryReader {
        private static final String A_CLASS = "class";
        private static final String E_MONITOR = "monitor";

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.services.markerlistener", MarkerMonitorRegistry.EXT_POINT);
        }

        protected boolean readElement(IConfigurationElement element) {
            boolean result = true;
            if (E_MONITOR.equals(element.getName())) {
                try {
                    MarkerMonitorRegistry.this.monitors.add((IMarkerMonitor)element.createExecutableExtension(A_CLASS));
                }
                catch (Exception e) {
                    result = false;
                    Activator.log.error("Failed to instantiate marker monitor extension.", (Throwable)e);
                }
            }
            return result;
        }
    }
}

