/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.internal;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.validation.Activator;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.internal.EcoreDiagnostician;

public class ValidationRegistry {
    public static final String ID_DIAGNOSTICIANS = "org.eclipse.papyrus.infra.services.validation.diagnosticians";

    public static IPapyrusDiagnostician getDiagnostician(EObject element) {
        try {
            ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(element);
            ILanguageService languageService = (ILanguageService)serviceRegistry.getService(ILanguageService.class);
            if (languageService != null) {
                Set languages = languageService.getLanguages(element.eResource().getURI(), true);
                for (ILanguage language : languages) {
                    IPapyrusDiagnostician diagnostician = ValidationRegistry.getDiagnostician(language.getID());
                    if (diagnostician == null) continue;
                    return diagnostician;
                }
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return new EcoreDiagnostician();
    }

    public static IPapyrusDiagnostician getDiagnostician(String languageID) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ID_DIAGNOSTICIANS);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String iConfiguratorIDext = configElement.getAttribute("id");
                if (iConfiguratorIDext != null && iConfiguratorIDext.equals(languageID) && (obj = configElement.createExecutableExtension("class")) instanceof IPapyrusDiagnostician) {
                    return (IPapyrusDiagnostician)obj;
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
        return null;
    }
}

