/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.ids;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.BindingsIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedCollectionTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedLambdaTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedMapTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedTupleTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.NsURIPackageIdImpl;
import org.eclipse.ocl.pivot.internal.ids.ParametersIdImpl;
import org.eclipse.ocl.pivot.internal.ids.PrimitiveTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.RootPackageIdImpl;
import org.eclipse.ocl.pivot.internal.ids.TemplateParameterIdImpl;
import org.eclipse.ocl.pivot.internal.ids.TuplePartIdImpl;
import org.eclipse.ocl.pivot.internal.ids.UnspecifiedIdImpl;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference2;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference3;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference4;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfWeakReference;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public final class IdManager {
    private static @NonNull IdManager PRIVATE_INSTANCE = new IdManager();
    public static final @NonNull RootPackageId METAMODEL = new RootPackageIdImpl(PRIVATE_INSTANCE, "$metamodel$");
    private static @Nullable WeakHashMapOfListOfWeakReference2<Integer, @NonNull ElementId @NonNull [], BindingsIdImpl> bindingsIds;
    private static @NonNull WeakHashMapOfWeakReference<String, CollectionTypeId> collectionNames;
    private static @NonNull WeakHashMapOfWeakReference<String, MapTypeId> mapNames;
    private static @NonNull WeakHashMapOfWeakReference<String, NsURIPackageId> nsURIs;
    private static @Nullable WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl> lambdaTypes;
    private static @Nullable WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl> tupleParts;
    private static @NonNull WeakHashMapOfWeakReference<String, RootPackageId> roots;
    private static @NonNull List<TemplateParameterId> templateParameters;
    private static @Nullable WeakHashMapOfListOfWeakReference3<@NonNull Integer, @NonNull String, @NonNull TuplePartId @NonNull [], GeneralizedTupleTypeIdImpl> tupleTypes;
    private static @Nullable WeakHashMapOfListOfWeakReference2<@NonNull Integer, @NonNull TypeId @NonNull [], ParametersIdImpl> parametersIds;
    private static @NonNull WeakHashMapOfWeakReference<String, PrimitiveTypeId> primitiveTypes;
    private static @Nullable Map<String, String> metamodelURI2name;

    static {
        collectionNames = new WeakHashMapOfWeakReference<String, CollectionTypeId>(){

            @Override
            protected @NonNull CollectionTypeId newId(@NonNull String name) {
                return new GeneralizedCollectionTypeIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        mapNames = new WeakHashMapOfWeakReference<String, MapTypeId>(){

            @Override
            protected @NonNull MapTypeId newId(@NonNull String name) {
                return new GeneralizedMapTypeIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        nsURIs = new WeakHashMapOfWeakReference<String, NsURIPackageId>(){

            @Override
            protected @NonNull NsURIPackageId newId(@NonNull String nsURI) {
                return new NsURIPackageIdImpl(PRIVATE_INSTANCE, nsURI, null, null);
            }
        };
        lambdaTypes = null;
        tupleParts = null;
        roots = new WeakHashMapOfWeakReference<String, RootPackageId>(){

            @Override
            protected @NonNull RootPackageId newId(@NonNull String name) {
                return new RootPackageIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        templateParameters = new ArrayList<TemplateParameterId>(10);
        tupleTypes = null;
        primitiveTypes = new WeakHashMapOfWeakReference<String, PrimitiveTypeId>(){

            @Override
            protected @NonNull PrimitiveTypeId newId(@NonNull String name) {
                return new PrimitiveTypeIdImpl(PRIVATE_INSTANCE, name);
            }
        };
        metamodelURI2name = null;
    }

    public static void addMetamodelEPackage(@NonNull String metamodelNsURI, @NonNull String metamodelName) {
        Map<String, String> metamodelURI2name2 = metamodelURI2name;
        if (metamodelURI2name2 == null) {
            metamodelURI2name = metamodelURI2name2 = new HashMap<String, String>();
        }
        metamodelURI2name2.put(metamodelNsURI, metamodelName);
    }

    public static @NonNull BindingsId getBindingsId(Type ... types) {
        @NonNull ElementId @NonNull [] elementIds = new ElementId[types.length];
        int i = 0;
        while (i < types.length) {
            elementIds[i] = types[i].getTypeId();
            ++i;
        }
        return IdManager.getBindingsId(elementIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static @NonNull BindingsId getBindingsId(ElementId ... elementIds) {
        WeakHashMapOfListOfWeakReference2<Integer, @NonNull ElementId @NonNull [], BindingsIdImpl> bindingsIds2 = bindingsIds;
        if (bindingsIds2 == null) {
            java.lang.Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.pivot.ids.IdManager.class
            bindingsIds2 = bindingsIds;
            if (bindingsIds2 == null) {
                bindingsIds = bindingsIds2 = new WeakHashMapOfListOfWeakReference2<Integer, ElementId[], BindingsIdImpl>(){

                    @Override
                    protected @NonNull BindingsIdImpl newId(@NonNull Integer hashCode, @NonNull ElementId @NonNull [] elementIds) {
                        return new BindingsIdImpl(PRIVATE_INSTANCE, hashCode, elementIds);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        @NonNull Integer hashCode = IdHash.createParametersHash(BindingsId.class, elementIds);
        return bindingsIds2.getId(hashCode, elementIds);
    }

    public static @NonNull ClassId getClassId(@NonNull Class aType) {
        if (aType.eIsProxy()) {
            return IdManager.getUnspecifiedTypeId(aType);
        }
        String name = aType.getName();
        assert (name != null);
        Package parentPackage = aType.getOwningPackage();
        if (parentPackage != null) {
            TemplateParameters typeParameters = aType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            return packageId.getClassId(name, typeParameters.parametersSize());
        }
        return IdManager.getUnspecifiedTypeId(aType);
    }

    public static @NonNull ClassId getClassId(@NonNull EClass eClass) {
        EPackage ePackage = ClassUtil.nonNullEMF(eClass.getEPackage());
        PackageId packageId = IdManager.getPackageId(ePackage);
        String className = ClassUtil.nonNullEMF(NameUtil.getOriginalName((ENamedElement)eClass));
        ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
        return classId;
    }

    public static @NonNull CollectionTypeId getCollectionTypeId(@NonNull String collectionTypeName) {
        return collectionNames.getId(collectionTypeName);
    }

    public static @NonNull DataTypeId getDataTypeId(@NonNull Class aType) {
        String name = aType.getName();
        assert (name != null);
        Package parentPackage = aType.getOwningPackage();
        if (parentPackage != null) {
            TemplateParameters typeParameters = aType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            return packageId.getDataTypeId(name, typeParameters.parametersSize());
        }
        return new UnspecifiedIdImpl(PRIVATE_INSTANCE, aType);
    }

    public static @NonNull EnumerationId getEnumerationId(@NonNull Enumeration anEnumeration) {
        String name = anEnumeration.getName();
        assert (name != null);
        Package parentPackage = anEnumeration.getOwningPackage();
        assert (parentPackage != null);
        return parentPackage.getPackageId().getEnumerationId(name);
    }

    public static @NonNull EnumerationId getEnumerationId(@NonNull EEnum eEnum) {
        String name = eEnum.getName();
        assert (name != null);
        EPackage parentPackage = eEnum.getEPackage();
        assert (parentPackage != null);
        return IdManager.getPackageId(parentPackage).getEnumerationId(name);
    }

    public static @NonNull EnumerationLiteralId getEnumerationLiteralId(@NonNull EEnumLiteral eEnumLiteral) {
        EEnum eEnum = ClassUtil.nonNullModel(eEnumLiteral.getEEnum());
        String name = ClassUtil.nonNullModel(eEnumLiteral.getName());
        EnumerationId enumerationId = IdManager.getEnumerationId(eEnum);
        EnumerationLiteralId enumerationLiteralId = enumerationId.getEnumerationLiteralId(name);
        return enumerationLiteralId;
    }

    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull LambdaType lambdaType) {
        String name = NameUtil.getSafeName(lambdaType);
        return IdManager.getLambdaTypeId(name, lambdaType.getParametersId());
    }

    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull String name, TypeId ... typeIds) {
        return IdManager.getLambdaTypeId(name, IdManager.getParametersId(typeIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull String name, @NonNull ParametersId parametersId) {
        WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl> lambdaTypes2 = lambdaTypes;
        if (lambdaTypes2 == null) {
            java.lang.Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.pivot.ids.IdManager.class
            lambdaTypes2 = lambdaTypes;
            if (lambdaTypes2 == null) {
                lambdaTypes = lambdaTypes2 = new WeakHashMapOfListOfWeakReference3<Integer, String, ParametersId, GeneralizedLambdaTypeIdImpl>(){

                    @Override
                    protected @NonNull GeneralizedLambdaTypeIdImpl newId(@NonNull Integer hashCode, @NonNull String name, @NonNull ParametersId parametersId) {
                        return new GeneralizedLambdaTypeIdImpl(hashCode, name, parametersId);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        int childHash = IdHash.createGlobalHash(LambdaTypeId.class, name);
        Integer hashCode = childHash + parametersId.hashCode();
        return (LambdaTypeId)lambdaTypes2.getId(hashCode, name, parametersId);
    }

    public static @NonNull MapTypeId getMapTypeId(@NonNull String mapTypeName) {
        return mapNames.getId(mapTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull NsURIPackageId getNsURIPackageId(@NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
        NsURIPackageId oldTypeId;
        WeakReference ref = (WeakReference)nsURIs.get(nsURI);
        if (ref != null && (oldTypeId = (NsURIPackageId)ref.get()) != null) {
            if (ePackage != null && oldTypeId.getEPackage() == null) {
                oldTypeId.setEPackage(ePackage);
            }
            return oldTypeId;
        }
        WeakHashMapOfWeakReference<String, NsURIPackageId> weakHashMapOfWeakReference = nsURIs;
        synchronized (weakHashMapOfWeakReference) {
            NsURIPackageId oldTypeId2;
            ref = (WeakReference)nsURIs.get(nsURI);
            if (ref != null && (oldTypeId2 = (NsURIPackageId)ref.get()) != null) {
                return oldTypeId2;
            }
            NsURIPackageIdImpl newTypeId = new NsURIPackageIdImpl(PRIVATE_INSTANCE, nsURI, nsPrefix, ePackage);
            nsURIs.put(nsURI, (NsURIPackageId)((Object)new WeakReference<NsURIPackageIdImpl>(newTypeId)));
            return newTypeId;
        }
    }

    public static @NonNull OperationId getOperationId(@NonNull Operation anOperation) {
        String name = NameUtil.getSafeName(anOperation);
        Class parentType = anOperation.getOwningClass();
        TypeId parentTypeId = parentType.getTypeId();
        @NonNull Type @NonNull [] parameterTypes = TypeUtil.getOperationParameterTypes(anOperation);
        TemplateParameters typeParameters = anOperation.getTypeParameters();
        ParametersId parametersId = IdManager.getParametersId(parameterTypes);
        return parentTypeId.getOperationId(typeParameters.parametersSize(), name, parametersId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static @NonNull TupleTypeId getOrderedTupleTypeId(@NonNull String name, @NonNull TuplePartId @NonNull [] parts) {
        WeakHashMapOfListOfWeakReference3<@NonNull Integer, @NonNull String, @NonNull TuplePartId @NonNull [], GeneralizedTupleTypeIdImpl> tupleTypes2 = tupleTypes;
        if (tupleTypes2 == null) {
            java.lang.Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.pivot.ids.IdManager.class
            tupleTypes2 = tupleTypes;
            if (tupleTypes2 == null) {
                tupleTypes = tupleTypes2 = new WeakHashMapOfListOfWeakReference3<Integer, String, TuplePartId[], GeneralizedTupleTypeIdImpl>(){

                    @Override
                    protected @NonNull GeneralizedTupleTypeIdImpl newId(@NonNull Integer hashCode, @NonNull String name, @NonNull TuplePartId @NonNull [] parts) {
                        return new GeneralizedTupleTypeIdImpl(PRIVATE_INSTANCE, hashCode, name, parts);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        int hash = IdHash.createTupleHash(name, parts);
        return tupleTypes2.getId(hash, name, parts);
    }

    public static @NonNull PackageId getPackageId(@NonNull Package aPackage) {
        String nsURI = aPackage.getURI();
        if (nsURI != null) {
            return IdManager.getNsURIPackageId(nsURI, aPackage.getNsPrefix(), aPackage.getEPackage());
        }
        String name = aPackage.getName();
        assert (name != null);
        Package parentPackage = aPackage.getOwningPackage();
        if (parentPackage != null) {
            return parentPackage.getPackageId().getNestedPackageId(name);
        }
        return IdManager.getRootPackageId(name);
    }

    public static @NonNull PackageId getPackageId(@NonNull EPackage aPackage) {
        if (ClassUtil.basicGetMetamodelAnnotation(aPackage) != null) {
            return METAMODEL;
        }
        String nsURI = aPackage.getNsURI();
        if (nsURI != null) {
            String metamodelName;
            if (metamodelURI2name != null && (metamodelName = metamodelURI2name.get(nsURI)) != null) {
                return IdManager.getRootPackageId(metamodelName);
            }
            return IdManager.getNsURIPackageId(nsURI, aPackage.getNsPrefix(), aPackage);
        }
        String name = aPackage.getName();
        assert (name != null);
        EPackage parentPackage = aPackage.getESuperPackage();
        if (parentPackage != null) {
            return IdManager.getPackageId(parentPackage).getNestedPackageId(name);
        }
        return IdManager.getNsURIPackageId(name, aPackage.getNsPrefix(), null);
    }

    public static @NonNull ParametersId getParametersId(@NonNull Type @NonNull [] parameterTypes) {
        int iSize = parameterTypes.length;
        @NonNull TypeId @NonNull [] typeIds = new TypeId[iSize];
        int i = 0;
        while (i < iSize) {
            Type parameterType = parameterTypes[i];
            boolean isNonNull = parameterType != null;
            typeIds[i] = isNonNull ? parameterType.getTypeId() : TypeId.OCL_INVALID;
            ++i;
        }
        return IdManager.getParametersId(typeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static @NonNull ParametersId getParametersId(TypeId ... typeIds) {
        WeakHashMapOfListOfWeakReference2<@NonNull Integer, @NonNull TypeId @NonNull [], ParametersIdImpl> parametersIds2 = parametersIds;
        if (parametersIds2 == null) {
            java.lang.Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.pivot.ids.IdManager.class
            parametersIds2 = parametersIds;
            if (parametersIds2 == null) {
                parametersIds = parametersIds2 = new WeakHashMapOfListOfWeakReference2<Integer, TypeId[], ParametersIdImpl>(){

                    @Override
                    protected @NonNull ParametersIdImpl newId(@NonNull Integer hashCode, @NonNull TypeId @NonNull [] typeIds) {
                        return new ParametersIdImpl(PRIVATE_INSTANCE, hashCode, typeIds);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        @NonNull Integer hashCode = IdHash.createParametersHash(ParametersId.class, typeIds);
        return parametersIds2.getId(hashCode, typeIds);
    }

    public static @NonNull PrimitiveTypeId getPrimitiveTypeId(@NonNull String name) {
        return primitiveTypes.getId(name);
    }

    public static @NonNull PropertyId getPropertyId(@NonNull EStructuralFeature eFeature) {
        String name = NameUtil.getOriginalName((ENamedElement)eFeature);
        assert (name != null);
        EClass parentClass = eFeature.getEContainingClass();
        assert (parentClass != null);
        ClassId classId = IdManager.getClassId(parentClass);
        return classId.getPropertyId(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull RootPackageId getRootPackageId(@NonNull String name) {
        RootPackageId oldTypeId;
        if ("$metamodel$".equals(name)) {
            return METAMODEL;
        }
        WeakReference ref = (WeakReference)roots.get(name);
        if (ref != null && (oldTypeId = (RootPackageId)ref.get()) != null) {
            return oldTypeId;
        }
        WeakHashMapOfWeakReference<String, RootPackageId> weakHashMapOfWeakReference = roots;
        synchronized (weakHashMapOfWeakReference) {
            RootPackageId oldTypeId2;
            ref = (WeakReference)roots.get(name);
            if (ref != null && (oldTypeId2 = (RootPackageId)ref.get()) != null) {
                return oldTypeId2;
            }
            RootPackageIdImpl newTypeId = new RootPackageIdImpl(PRIVATE_INSTANCE, name);
            roots.put(name, (RootPackageId)((Object)new WeakReference<RootPackageIdImpl>(newTypeId)));
            return newTypeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull TemplateParameterId getTemplateParameterId(int index) {
        if (index >= templateParameters.size()) {
            List<TemplateParameterId> list = templateParameters;
            synchronized (list) {
                while (index >= templateParameters.size()) {
                    templateParameters.add(new TemplateParameterIdImpl(PRIVATE_INSTANCE, templateParameters.size()));
                }
            }
        }
        TemplateParameterId templateParameterId = templateParameters.get(index);
        assert (templateParameterId != null);
        return templateParameterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static @NonNull TuplePartId getTuplePartId(int index, @NonNull String name, @NonNull TypeId typeId) {
        WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl> tupleParts2 = tupleParts;
        if (tupleParts2 == null) {
            java.lang.Class<IdManager> clazz = IdManager.class;
            // MONITORENTER : org.eclipse.ocl.pivot.ids.IdManager.class
            tupleParts2 = tupleParts;
            if (tupleParts2 == null) {
                tupleParts = tupleParts2 = new WeakHashMapOfListOfWeakReference4<Integer, Integer, String, TypeId, TuplePartIdImpl>(){

                    @Override
                    protected @NonNull TuplePartIdImpl newId(@NonNull Integer hashCode, @NonNull Integer index, @NonNull String name, @NonNull TypeId typeId) {
                        return new TuplePartIdImpl(PRIVATE_INSTANCE, hashCode, index, name, typeId);
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        Integer hashCode = name.hashCode() + 7 * typeId.hashCode() + 989 * index;
        return (TuplePartId)tupleParts2.getId(hashCode, index, name, typeId);
    }

    public static @NonNull TupleTypeId getTupleTypeId(@NonNull String name, @NonNull Collection<@NonNull ? extends TuplePartId> parts) {
        @NonNull Object @NonNull [] orderedParts = new TuplePartId[parts.size()];
        int i = 0;
        for (TuplePartId tuplePartId : parts) {
            orderedParts[i++] = tuplePartId;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    public static @NonNull TupleTypeId getTupleTypeId(@NonNull String name, TuplePartId ... parts) {
        @NonNull Object @NonNull [] orderedParts = new TuplePartId[parts.length];
        int i = 0;
        TuplePartId[] tuplePartIdArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId part = tuplePartIdArray[n2];
            orderedParts[i++] = part;
            ++n2;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    public static @NonNull TypeId getTypeId(@NonNull EClassifier eClassifier) {
        String name = NameUtil.getOriginalName((ENamedElement)eClassifier);
        assert (name != null);
        EPackage parentPackage = eClassifier.getEPackage();
        assert (parentPackage != null);
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters != null);
        PackageId packageId = IdManager.getPackageId(parentPackage);
        int eTypeParameterCount = eTypeParameters.size();
        if (eClassifier instanceof EEnum) {
            return packageId.getEnumerationId(name);
        }
        if (eClassifier instanceof EDataType) {
            return packageId.getDataTypeId(name, eTypeParameterCount);
        }
        return packageId.getClassId(name, eTypeParameterCount);
    }

    public static @NonNull UnspecifiedIdImpl getUnspecifiedTypeId(@NonNull Type aType) {
        UnspecifiedIdImpl newId = new UnspecifiedIdImpl(PRIVATE_INSTANCE, aType);
        return newId;
    }

    private IdManager() {
    }
}

