/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class LambdaTypeManager {
    protected final @NonNull CompleteEnvironmentInternal completeEnvironment;
    protected final @NonNull Class oclLambdaType;
    private final @NonNull Map<Type, Map<Type, List<LambdaType>>> lambdaTypes = new HashMap<Type, Map<Type, List<LambdaType>>>();

    public LambdaTypeManager(@NonNull CompleteEnvironmentInternal allCompleteClasses) {
        this.completeEnvironment = allCompleteClasses;
        this.oclLambdaType = allCompleteClasses.getOwnedStandardLibrary().getOclLambdaType();
    }

    public void dispose() {
        this.lambdaTypes.clear();
    }

    public @NonNull LambdaType getLambdaType(@NonNull String typeName, @NonNull Type contextType, @NonNull List<? extends Type> parameterTypes, @NonNull Type resultType, @Nullable TemplateParameterSubstitutions bindings) {
        if (bindings == null) {
            return this.getLambdaType(typeName, contextType, parameterTypes, resultType);
        }
        Type specializedContextType = this.completeEnvironment.getSpecializedType(contextType, bindings);
        ArrayList<Type> specializedParameterTypes = new ArrayList<Type>();
        for (Type type : parameterTypes) {
            if (type == null) continue;
            specializedParameterTypes.add(this.completeEnvironment.getSpecializedType(type, bindings));
        }
        Type type = this.completeEnvironment.getSpecializedType(resultType, bindings);
        return this.getLambdaType(typeName, specializedContextType, specializedParameterTypes, type);
    }

    private @NonNull LambdaType getLambdaType(@NonNull String typeName, @NonNull Type contextType, @NonNull List<? extends Type> parameterTypes, @NonNull Type resultType) {
        int iMax;
        Type firstParameterType;
        List<LambdaType> lambdasList;
        Map<Type, List<LambdaType>> contextMap = this.lambdaTypes.get(contextType);
        if (contextMap == null) {
            contextMap = new HashMap<Type, List<LambdaType>>();
            this.lambdaTypes.put(contextType, contextMap);
        }
        if ((lambdasList = contextMap.get(firstParameterType = (iMax = parameterTypes.size()) > 0 ? parameterTypes.get(0) : null)) == null) {
            lambdasList = new ArrayList<LambdaType>();
            contextMap.put(firstParameterType, lambdasList);
        }
        for (LambdaType candidateLambda : lambdasList) {
            List<Type> candidateTypes;
            if (resultType != candidateLambda.getResultType() || iMax != (candidateTypes = candidateLambda.getParameterType()).size()) continue;
            boolean gotIt = true;
            int i = 1;
            while (i < iMax) {
                Type candidateType;
                Type requiredType = parameterTypes.get(i);
                if (requiredType != (candidateType = candidateTypes.get(i))) {
                    gotIt = false;
                    break;
                }
                ++i;
            }
            if (!gotIt) continue;
            return candidateLambda;
        }
        LambdaType lambdaType = PivotFactory.eINSTANCE.createLambdaType();
        lambdaType.setName(typeName);
        lambdaType.setContextType(contextType);
        lambdaType.getParameterType().addAll(parameterTypes);
        lambdaType.setResultType(resultType);
        lambdaType.getSuperClasses().add(this.oclLambdaType);
        this.completeEnvironment.addOrphanClass(lambdaType);
        lambdasList.add(lambdaType);
        return lambdaType;
    }
}

