/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class CompleteElementIterable<O, I>
implements Iterable<I> {
    protected final @NonNull Iterable<? extends O> iterables;

    public CompleteElementIterable(@NonNull Iterable<? extends O> iterables) {
        this.iterables = iterables;
    }

    protected abstract Iterable<I> getInnerIterable(@NonNull O var1);

    protected I getInnerValue(@NonNull I element) {
        return element;
    }

    @Override
    public @NonNull java.util.Iterator<I> iterator() {
        if (this.iterables instanceof List) {
            List list = (List)this.iterables;
            if (list.size() == 0) {
                @NonNull UnmodifiableIterator result = Iterators.emptyIterator();
                return result;
            }
            if (list.size() == 1) {
                Iterable<I> innerIterable;
                Object listEntry = list.get(0);
                if (listEntry != null && (innerIterable = this.getInnerIterable(listEntry)) != null) {
                    @NonNull java.util.Iterator<I> result = innerIterable.iterator();
                    return result;
                }
                @NonNull UnmodifiableIterator result = Iterators.emptyIterator();
                return result;
            }
        }
        return new Iterator(this.iterables);
    }

    protected class Iterator
    implements java.util.Iterator<I> {
        private final java.util.Iterator<? extends O> outerIterator;
        private java.util.Iterator<I> innerIterator;
        private @Nullable I nextValue;

        public Iterator(Iterable<? extends O> iterables) {
            this.outerIterator = iterables.iterator();
            this.innerIterator = null;
            this.advance();
        }

        protected boolean advance() {
            while (true) {
                if (this.innerIterator != null) {
                    while (this.innerIterator.hasNext()) {
                        this.nextValue = CompleteElementIterable.this.getInnerValue(ClassUtil.nonNullState(this.innerIterator.next()));
                        if (this.nextValue == null) continue;
                        return true;
                    }
                }
                if (!this.outerIterator.hasNext()) break;
                Iterable innerIterable = CompleteElementIterable.this.getInnerIterable(ClassUtil.nonNullState(this.outerIterator.next()));
                if (innerIterable == null) continue;
                this.innerIterator = innerIterable.iterator();
            }
            this.nextValue = null;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public I next() {
            try {
                if (this.nextValue != null) {
                    Object i = this.nextValue;
                    return i;
                }
                throw new NoSuchElementException();
            }
            finally {
                this.advance();
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

