/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.NodeImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.opencert.infra.general.general.impl.NamedElementImpl;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefActivity2EditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefActivityEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefArtefactEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefRoleEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AssociateDiagramAction
extends Action {
    private static int cont = 0;
    public static final String ACTION_ASSOCIATE = "AS";
    public static final String ACTION_DISSOCIATE = "DS";
    private static final String ASSOCIATE_REQUEST = "Associate";
    private static final String DISSOCIATE_REQUEST = "Dissociate";
    private String actionId;
    private HashMap actionMap = new HashMap();
    private String diagramfullFileName;
    private EditPart editPart;
    private ISelection selection;

    public AssociateDiagramAction(String diagramFile, ISelection selection, String actionId) {
        this.actionMap.put(ACTION_ASSOCIATE, ASSOCIATE_REQUEST);
        this.actionMap.put(ACTION_DISSOCIATE, DISSOCIATE_REQUEST);
        this.diagramfullFileName = "";
        String kk = "platform:/resource/";
        int lastInd = diagramFile.length();
        this.diagramfullFileName = diagramFile.substring(kk.length(), lastInd);
        this.actionId = actionId;
        this.selection = selection;
        this.editPart = null;
    }

    public void init() {
        if (!this.diagramfullFileName.contains(".refframework_diagram")) {
            return;
        }
        int beginInd = this.diagramfullFileName.lastIndexOf("\\");
        if (beginInd == -1) {
            beginInd = this.diagramfullFileName.lastIndexOf("/");
        }
        if (this.actionId.equals(ACTION_ASSOCIATE)) {
            this.setId("associateDiagram" + ++cont);
            this.setText("Associate diagram " + this.diagramfullFileName.substring(beginInd + 1));
            this.setToolTipText("Associate diagram......");
        } else if (this.actionId.equals(ACTION_DISSOCIATE)) {
            this.setId("dissociateDiagram" + ++cont);
            this.setText("Dissociate diagram " + this.diagramfullFileName.substring(beginInd + 1));
            this.setToolTipText("Dissociate diagram......");
        }
    }

    protected String getCommandLabel() {
        return "MCP Action";
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        IStructuredSelection s = (IStructuredSelection)selection;
        s = (IStructuredSelection)this.selection;
        if (s != null && !s.isEmpty() && (s.getFirstElement() instanceof RefActivityEditPart || s.getFirstElement() instanceof RefActivity2EditPart || s.getFirstElement() instanceof RefArtefactEditPart || s.getFirstElement() instanceof RefRoleEditPart)) {
            this.editPart = (EditPart)s.getFirstElement();
        }
        if (this.editPart != null) {
            View view = (View)this.editPart.getModel();
            EObject element = view.getElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
            AssociateDiagramCommand cmd = new AssociateDiagramCommand(domain, "test associate MCP", null);
            cmd.init(view, this.diagramfullFileName);
            try {
                cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected HintedDiagramLinkStyle getHintedDiagramLink(View view, String diagramName) {
        HintedDiagramLinkStyle diagramFacet = null;
        boolean found = false;
        for (Object element : view.getStyles()) {
            HintedDiagramLinkStyle elementHD;
            if (!(element instanceof HintedDiagramLinkStyle) || (elementHD = (HintedDiagramLinkStyle)element).getHint() == null || elementHD.getHint().compareTo("Sub" + diagramName) != 0) continue;
            found = true;
            diagramFacet = elementHD;
        }
        if (!found) {
            String diagramFacetName = "Sub" + diagramName;
            diagramFacet = NotationFactory.eINSTANCE.createHintedDiagramLinkStyle();
            diagramFacet.setHint(diagramFacetName);
            view.getStyles().add((Object)diagramFacet);
        }
        return diagramFacet;
    }

    protected HintedDiagramLinkStyle addHintedDiagramLink(View view, String diagramName) {
        HintedDiagramLinkStyle diagramFacet = null;
        boolean found = false;
        for (Object element : view.getStyles()) {
            HintedDiagramLinkStyle elementHD;
            if (!(element instanceof HintedDiagramLinkStyle) || (elementHD = (HintedDiagramLinkStyle)element).getHint() == null || elementHD.getHint().compareTo("Sub" + diagramName) != 0) continue;
            found = true;
            diagramFacet = elementHD;
        }
        if (!found) {
            String diagramFacetName = "Sub" + diagramName;
            diagramFacet = NotationFactory.eINSTANCE.createHintedDiagramLinkStyle();
            diagramFacet.setHint(diagramFacetName);
            view.getStyles().add((Object)diagramFacet);
        }
        return diagramFacet;
    }

    public class AssociateDiagramCommand
    extends AbstractTransactionalCommand {
        TransactionalEditingDomain myEditingDomain;
        View view;
        String diagramfullFileName;

        public AssociateDiagramCommand(TransactionalEditingDomain domain, String label, List affectedFiles) {
            super(domain, label, affectedFiles);
            this.myEditingDomain = domain;
        }

        public void init(View view, String diagramfullFileName) {
            this.view = view;
            this.diagramfullFileName = diagramfullFileName;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                HintedDiagramLinkStyle hinted = AssociateDiagramAction.this.getHintedDiagramLink(this.view, this.diagramfullFileName);
                Diagram diagram = hinted.getDiagramLink();
                if (diagram == null) {
                    diagram = this.intializeNewDiagram(hinted);
                }
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't associate the diagram", (Throwable)ex);
            }
        }

        protected String getDiagramKind() {
            return "Refframework";
        }

        protected String getEditorID() {
            return "org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorID";
        }

        public boolean copyToFile(String contentSourceFile, File destFile) throws IOException {
            BufferedWriter writer = new BufferedWriter(new FileWriter(destFile));
            writer.write(contentSourceFile);
            return true;
        }

        protected Diagram intializeNewDiagram(final HintedDiagramLinkStyle diagramFacet) throws ExecutionException {
            Diagram d;
            NodeImpl sh = (NodeImpl)diagramFacet.eContainer();
            NamedElementImpl neImpl = (NamedElementImpl)sh.basicGetElement();
            if (neImpl == null || neImpl.getName() == null) {
                throw new ExecutionException("Can't associate a diagram to the element");
            }
            String diagramFName = this.diagramfullFileName;
            URI diagramURI = URI.createPlatformResourceURI((String)diagramFName, (boolean)false);
            this.myEditingDomain.getResourceSet();
            Resource diagramResource = this.myEditingDomain.getResourceSet().getResource(diagramURI.trimFragment(), false);
            if (diagramResource == null) {
                diagramResource = this.myEditingDomain.getResourceSet().createResource(diagramURI.trimFragment());
            }
            if (!diagramResource.isLoaded()) {
                try {
                    HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                    diagramResource.load(options);
                }
                catch (IOException iOException) {
                    diagramResource.unload();
                    throw new ExecutionException("Can't lod diagram'");
                }
            }
            if ((d = (Diagram)diagramResource.getContents().get(0)) == null) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind");
            }
            d.setName(this.diagramfullFileName);
            diagramFacet.setDiagramLink(d);
            assert (diagramFacet.eResource() != null);
            EObject container = diagramFacet.eContainer();
            while (container instanceof View) {
                ((View)container).persist();
                container = container.eContainer();
            }
            try {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            for (Resource nextResource : diagramFacet.eResource().getResourceSet().getResources()) {
                                if (!nextResource.isLoaded() || AssociateDiagramCommand.this.getEditingDomain().isReadOnly(nextResource)) continue;
                                nextResource.save(RefframeworkDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (IOException ex) {
                            throw new InvocationTargetException(ex, "Save operation failed");
                        }
                    }
                }.run(null);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            return d;
        }
    }
}

