/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefActivity2EditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefActivityEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefArtefactEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.edit.parts.RefRoleEditPart;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenAssociatedDiagramAction
extends Action {
    private static int cont = 0;
    public static final String ACTION_OPEN = "OP";
    private static final String OPEN_REQUEST = "Open";
    private String actionId;
    private String diagramfullFileName = "";
    private EditPart editPart;
    private ISelection selection;

    public OpenAssociatedDiagramAction(String diagramFile, ISelection selection, String actionId) {
        String kk = "platform:/resource/";
        int lastInd = diagramFile.length();
        this.diagramfullFileName = diagramFile.substring(kk.length(), lastInd);
        this.actionId = actionId;
        this.selection = selection;
        this.editPart = null;
    }

    public void init() {
        if (!this.diagramfullFileName.contains(".refframework_diagram")) {
            return;
        }
        int beginInd = this.diagramfullFileName.lastIndexOf("\\");
        if (beginInd == -1) {
            beginInd = this.diagramfullFileName.lastIndexOf("/");
        }
        if (this.actionId.equals(ACTION_OPEN)) {
            this.setId("openAssociatedDiagram" + ++cont);
            this.setText("Open associated diagram " + this.diagramfullFileName.substring(beginInd + 1));
            this.setToolTipText("Open diagram......");
        }
    }

    protected String getCommandLabel() {
        return "MCP Action";
    }

    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        IStructuredSelection s = (IStructuredSelection)selection;
        s = (IStructuredSelection)this.selection;
        if (s != null && !s.isEmpty() && (s.getFirstElement() instanceof RefActivityEditPart || s.getFirstElement() instanceof RefActivity2EditPart || s.getFirstElement() instanceof RefArtefactEditPart || s.getFirstElement() instanceof RefRoleEditPart)) {
            this.editPart = (EditPart)s.getFirstElement();
        }
        if (this.editPart != null) {
            View view = (View)this.editPart.getModel();
            EObject element = view.getElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
            OpenAssociatedDiagramCommand cmd = new OpenAssociatedDiagramCommand(domain, "test associate MCP", null);
            cmd.init(view, this.diagramfullFileName);
            try {
                cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected HintedDiagramLinkStyle getHintedDiagramLink(View view, String diagramName) {
        HintedDiagramLinkStyle diagramFacet = null;
        boolean found = false;
        for (Object element : view.getStyles()) {
            HintedDiagramLinkStyle elementHD;
            if (!(element instanceof HintedDiagramLinkStyle) || (elementHD = (HintedDiagramLinkStyle)element).getHint() == null || elementHD.getHint().compareTo("Sub" + diagramName) != 0) continue;
            found = true;
            diagramFacet = elementHD;
        }
        if (!found) {
            System.out.println("getHintedDiagramLink: Error HintedDiagramLink not found ()" + diagramName);
        }
        return diagramFacet;
    }

    public class OpenAssociatedDiagramCommand
    extends AbstractTransactionalCommand {
        TransactionalEditingDomain myEditingDomain;
        View view;
        String diagramfullFileName;

        public OpenAssociatedDiagramCommand(TransactionalEditingDomain domain, String label, List affectedFiles) {
            super(domain, label, affectedFiles);
            this.myEditingDomain = domain;
        }

        public void init(View view, String diagramfullFileName) {
            this.view = view;
            this.diagramfullFileName = diagramfullFileName;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                HintedDiagramLinkStyle hinted = OpenAssociatedDiagramAction.this.getHintedDiagramLink(this.view, this.diagramfullFileName);
                if (hinted == null) {
                    throw new ExecutionException("Can't open diagram'");
                }
                Diagram diagram = hinted.getDiagramLink();
                if (diagram != null && this.diagramfullFileName.contains(diagram.getName())) {
                    URI uri = EcoreUtil.getURI((EObject)diagram);
                    Resource diagramResource = this.myEditingDomain.getResourceSet().getResource(uri.trimFragment(), false);
                    if (!diagramResource.isLoaded()) {
                        try {
                            HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                            diagramResource.load(options);
                        }
                        catch (IOException iOException) {
                            diagramResource.unload();
                            throw new ExecutionException("Can't load diagram'");
                        }
                    }
                    RefframeworkDiagramEditorUtil.openDiagram(diagramResource);
                }
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't associate the diagram", (Throwable)ex);
            }
        }

        protected String getEditorID() {
            return "org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorID";
        }
    }
}

