/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.modelelement;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.properties.ui.creation.PropertyEditorFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElementFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;

public abstract class AbstractModelElement
implements ModelElement,
IDataSourceListener {
    protected DataSource dataSource;
    private final Map<String, IObservable> observables = new HashMap<String, IObservable>();
    private IDisposeListener observableDisposeListener;
    AbstractModelElementFactory<AbstractModelElement> factory;

    protected AbstractModelElement() {
    }

    void setFactory(AbstractModelElementFactory<? extends AbstractModelElement> factory) {
        this.factory = factory;
    }

    @Override
    public IStaticContentProvider getContentProvider(String propertyPath) {
        return EmptyContentProvider.instance;
    }

    @Override
    public ILabelProvider getLabelProvider(String propertyPath) {
        return null;
    }

    @Override
    public boolean isOrdered(String propertyPath) {
        return true;
    }

    @Override
    public boolean isUnique(String propertyPath) {
        return false;
    }

    @Override
    public boolean isMandatory(String propertyPath) {
        return false;
    }

    @Override
    public boolean isEditable(String propertyPath) {
        return true;
    }

    @Override
    public boolean forceRefresh(String propertyPath) {
        return false;
    }

    @Override
    public void setDataSource(DataSource source) {
        if (this.dataSource != source) {
            if (this.dataSource != null) {
                this.dataSource.removeDataSourceListener(this);
            }
            this.dataSource = source;
            if (this.dataSource != null) {
                this.dataSource.addDataSourceListener(this);
            }
        }
    }

    @Override
    public final void dataSourceChanged(DataSourceChangedEvent event) {
        if (event.getDataSource() == this.dataSource) {
            IStructuredSelection selection = this.dataSource.getSelection();
            if (selection.isEmpty()) {
                this.factory.updateModelElement(this, null);
            } else if (selection.size() == 1) {
                this.factory.updateModelElement(this, selection.getFirstElement());
            } else {
                this.updateMultipleSelection(selection);
            }
            for (Map.Entry<String, IObservable> next : this.observables.entrySet()) {
                IDelegatingObservable wrapper = (IDelegatingObservable)next.getValue();
                wrapper.setDelegate(this.doGetObservable(next.getKey()));
            }
        }
    }

    void updateMultipleSelection(IStructuredSelection selection) {
        throw new IllegalArgumentException("multiple selection");
    }

    @Override
    public ReferenceValueFactory getValueFactory(String propertyPath) {
        return new PropertyEditorFactory();
    }

    @Override
    public Object getDefaultValue(String propertyPath) {
        return null;
    }

    @Override
    public boolean getDirectCreation(String propertyPath) {
        return false;
    }

    @Override
    public final IObservable getObservable(String propertyPath) {
        IObservable observable;
        if (!this.observables.containsKey(propertyPath) && (observable = this.doGetObservable(propertyPath)) != null) {
            observable = DelegatingObservable.wrap((IObservable)observable);
            observable.addDisposeListener(this.getObservableDisposeListener());
            ReferenceCountedObservable.Util.retain((IObservable)observable);
            this.observables.put(propertyPath, observable);
        }
        return this.observables.get(propertyPath);
    }

    protected abstract IObservable doGetObservable(String var1);

    @Override
    public void dispose() {
        for (IObservable observable : this.observables.values()) {
            if (this.observableDisposeListener != null) {
                observable.removeDisposeListener(this.observableDisposeListener);
            }
            ReferenceCountedObservable.Util.release((IObservable)observable);
        }
        this.observables.clear();
        this.observableDisposeListener = null;
    }

    @Override
    public IValidator getValidator(String propertyPath) {
        return null;
    }

    private IDisposeListener getObservableDisposeListener() {
        if (this.observableDisposeListener == null) {
            this.observableDisposeListener = new IDisposeListener(){

                public void handleDispose(DisposeEvent event) {
                    Iterator entries = AbstractModelElement.this.observables.entrySet().iterator();
                    while (entries.hasNext()) {
                        if (entries.next().getValue() != event.getObservable()) continue;
                        entries.remove();
                        break;
                    }
                }
            };
        }
        return this.observableDisposeListener;
    }

    @Override
    public INameResolutionHelper getNameResolutionHelper(String propertyPath) {
        return null;
    }

    @Override
    public IPapyrusConverter getPapyrusConverter(String propertyPath) {
        return null;
    }
}

