/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scale;

public class TimeSlider
extends Scale
implements IListener,
ITreeViewerListener {
    private static final int MIN = 0;
    private static final int MAX = 100000;
    private static final double FACTOR = 100000.0;
    private final Set<CDOID> expandedIDs = new HashSet<CDOID>();
    private long startTimeStamp;
    private long endTimeStamp;
    private long absoluteTimeWindowLength;
    private double stepSize;
    private long timeStamp;
    private CDOStaleReferencePolicy.DynamicProxy.Enhanced staleReferencePolicy;
    private CDOView view;
    private TreeViewer viewer;

    public TimeSlider(Composite parent, int style) {
        super(parent, style);
        this.setMinimum(0);
        this.setMaximum(100000);
        this.setSelection(100000);
        this.setPageIncrement(100000);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long value = TimeSlider.this.getSelection();
                long timeStamp = TimeSlider.this.startTimeStamp + Math.round(TimeSlider.this.stepSize * (double)value);
                TimeSlider.this.setTimeStamp(timeStamp);
                if (TimeSlider.this.viewer != null) {
                    TimeSlider.this.viewer.refresh();
                    this.setExpandedStates();
                }
            }

            protected void setExpandedStates() {
                for (CDOID id : TimeSlider.this.expandedIDs) {
                    try {
                        CDOObject object = TimeSlider.this.view.getObject(id);
                        TimeSlider.this.viewer.setExpandedState((Object)object, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (timeStamp == 0L) {
            timeStamp = this.endTimeStamp;
        } else if (timeStamp < this.startTimeStamp) {
            timeStamp = this.startTimeStamp;
        } else if (timeStamp > this.endTimeStamp) {
            timeStamp = this.endTimeStamp;
        }
        if (this.timeStamp != timeStamp) {
            this.timeStamp = timeStamp;
            final int newSelection = (int)((double)(timeStamp - this.startTimeStamp) / this.stepSize);
            Display display = this.getDisplay();
            if (display == Display.getCurrent()) {
                if (this.getSelection() != newSelection) {
                    this.setSelection(newSelection);
                }
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (TimeSlider.this.getSelection() != newSelection) {
                            TimeSlider.this.setSelection(newSelection);
                        }
                    }
                });
            }
            this.timeStampChanged(timeStamp);
        }
    }

    public void connect(CDOView view, TreeViewer viewer) {
        if (this.view != view) {
            this.disconnect();
            if (view != null) {
                CDOSession session;
                this.view = view;
                this.viewer = viewer;
                CDOBranchPointRange lifetime = null;
                if (this.viewer != null) {
                    Object[] objectArray = viewer.getExpandedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        CDOID id = this.getID(element);
                        if (id != null) {
                            this.expandedIDs.add(id);
                        }
                        ++n2;
                    }
                    this.viewer.addTreeListener((ITreeViewerListener)this);
                    Object input = viewer.getInput();
                    if (input instanceof EObject) {
                        lifetime = CDOUtil.getLifetime((CDOObject)CDOUtil.getCDOObject((EObject)((EObject)input)));
                    }
                }
                if (lifetime == null) {
                    session = view.getSession();
                    CDOBranch branch = view.getBranch();
                    CDOBranchPoint firstPoint = branch.getPoint(session.getRepositoryInfo().getCreationTime());
                    CDOBranchPoint lastPoint = branch.getHead();
                    lifetime = CDOBranchUtil.createRange((CDOBranchPoint)firstPoint, (CDOBranchPoint)lastPoint);
                }
                this.startTimeStamp = lifetime.getStartPoint().getTimeStamp();
                this.endTimeStamp = lifetime.getEndPoint().getTimeStamp();
                if (this.endTimeStamp == 0L) {
                    session = view.getSession();
                    this.endTimeStamp = session.getLastUpdateTime();
                }
                this.absoluteTimeWindowLength = this.endTimeStamp - this.startTimeStamp;
                this.stepSize = (double)this.absoluteTimeWindowLength / 100000.0;
                this.setTimeStamp(view.getTimeStamp());
                this.staleReferencePolicy = new CDOStaleReferencePolicy.DynamicProxy.Enhanced(view);
                view.addListener((IListener)this);
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else if (this.view == null) {
            this.setEnabled(false);
        }
    }

    public void disconnect() {
        if (this.view != null) {
            if (this.staleReferencePolicy != null) {
                this.view.removeListener((IListener)this);
                this.staleReferencePolicy.dispose();
                this.staleReferencePolicy = null;
                if (this.viewer != null) {
                    this.expandedIDs.clear();
                    this.viewer.removeTreeListener((ITreeViewerListener)this);
                    this.viewer = null;
                }
            }
            this.view = null;
        }
    }

    public void notifyEvent(IEvent event) {
        ILifecycleEvent e;
        if (event instanceof CDOViewTargetChangedEvent) {
            CDOViewTargetChangedEvent e2 = (CDOViewTargetChangedEvent)event;
            this.setTimeStamp(e2.getBranchPoint().getTimeStamp());
        } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE) {
            this.disconnect();
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        CDOID id = this.getID(event.getElement());
        if (id != null) {
            this.expandedIDs.add(id);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        CDOID id = this.getID(event.getElement());
        if (id != null) {
            this.expandedIDs.remove(id);
        }
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }

    protected void timeStampChanged(long timeStamp) {
        if (this.view != null) {
            this.view.setTimeStamp(timeStamp);
        }
    }

    protected void checkSubclass() {
    }

    private CDOID getID(Object element) {
        CDOObject object;
        if (element instanceof EObject && (object = CDOUtil.getCDOObject((EObject)((EObject)element), (boolean)false)) != null) {
            return object.cdoID();
        }
        return null;
    }
}

