/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.AssistantRuleItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.CategoryItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.ChildRuleItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.ConfigurationEditPlugin;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.ModelAutoCreateItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.ModelRuleItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.OwningRuleItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PaletteRuleItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusConfigurationItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusDiagramItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusSyncTableItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusTableItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusViewItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PapyrusViewpointItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.PathElementItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.RootAutoSelectItemProvider;
import org.eclipse.papyrus.infra.viewpoints.configuration.util.ConfigurationAdapterFactory;
import org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureDescription;
import org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureFramework;
import org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Iso42010Package;
import org.eclipse.papyrus.infra.viewpoints.iso42010.util.Iso42010Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemProviderAdapterFactory
extends ConfigurationAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable,
IChildCreationExtender {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager((ResourceLocator)ConfigurationEditPlugin.INSTANCE, "http://www.eclipse.org/papyrus/infra/viewpoints/configuration");
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected PapyrusConfigurationItemProvider papyrusConfigurationItemProvider;
    protected PapyrusViewpointItemProvider papyrusViewpointItemProvider;
    protected PapyrusViewItemProvider papyrusViewItemProvider;
    protected PapyrusDiagramItemProvider papyrusDiagramItemProvider;
    protected PapyrusSyncTableItemProvider papyrusSyncTableItemProvider;
    protected PapyrusTableItemProvider papyrusTableItemProvider;
    protected ModelRuleItemProvider modelRuleItemProvider;
    protected OwningRuleItemProvider owningRuleItemProvider;
    protected ChildRuleItemProvider childRuleItemProvider;
    protected PaletteRuleItemProvider paletteRuleItemProvider;
    protected PathElementItemProvider pathElementItemProvider;
    protected CategoryItemProvider categoryItemProvider;
    protected ModelAutoCreateItemProvider modelAutoCreateItemProvider;
    protected RootAutoSelectItemProvider rootAutoSelectItemProvider;
    protected AssistantRuleItemProvider assistantRuleItemProvider;

    public ConfigurationItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createPapyrusConfigurationAdapter() {
        if (this.papyrusConfigurationItemProvider == null) {
            this.papyrusConfigurationItemProvider = new PapyrusConfigurationItemProvider((AdapterFactory)this);
        }
        return this.papyrusConfigurationItemProvider;
    }

    public Adapter createPapyrusViewpointAdapter() {
        if (this.papyrusViewpointItemProvider == null) {
            this.papyrusViewpointItemProvider = new PapyrusViewpointItemProvider((AdapterFactory)this);
        }
        return this.papyrusViewpointItemProvider;
    }

    public Adapter createPapyrusViewAdapter() {
        if (this.papyrusViewItemProvider == null) {
            this.papyrusViewItemProvider = new PapyrusViewItemProvider((AdapterFactory)this);
        }
        return this.papyrusViewItemProvider;
    }

    public Adapter createPapyrusDiagramAdapter() {
        if (this.papyrusDiagramItemProvider == null) {
            this.papyrusDiagramItemProvider = new PapyrusDiagramItemProvider((AdapterFactory)this);
        }
        return this.papyrusDiagramItemProvider;
    }

    public Adapter createPapyrusSyncTableAdapter() {
        if (this.papyrusSyncTableItemProvider == null) {
            this.papyrusSyncTableItemProvider = new PapyrusSyncTableItemProvider((AdapterFactory)this);
        }
        return this.papyrusSyncTableItemProvider;
    }

    public Adapter createPapyrusTableAdapter() {
        if (this.papyrusTableItemProvider == null) {
            this.papyrusTableItemProvider = new PapyrusTableItemProvider((AdapterFactory)this);
        }
        return this.papyrusTableItemProvider;
    }

    public Adapter createModelRuleAdapter() {
        if (this.modelRuleItemProvider == null) {
            this.modelRuleItemProvider = new ModelRuleItemProvider((AdapterFactory)this);
        }
        return this.modelRuleItemProvider;
    }

    public Adapter createOwningRuleAdapter() {
        if (this.owningRuleItemProvider == null) {
            this.owningRuleItemProvider = new OwningRuleItemProvider((AdapterFactory)this);
        }
        return this.owningRuleItemProvider;
    }

    public Adapter createChildRuleAdapter() {
        if (this.childRuleItemProvider == null) {
            this.childRuleItemProvider = new ChildRuleItemProvider((AdapterFactory)this);
        }
        return this.childRuleItemProvider;
    }

    public Adapter createPaletteRuleAdapter() {
        if (this.paletteRuleItemProvider == null) {
            this.paletteRuleItemProvider = new PaletteRuleItemProvider((AdapterFactory)this);
        }
        return this.paletteRuleItemProvider;
    }

    public Adapter createPathElementAdapter() {
        if (this.pathElementItemProvider == null) {
            this.pathElementItemProvider = new PathElementItemProvider((AdapterFactory)this);
        }
        return this.pathElementItemProvider;
    }

    public Adapter createCategoryAdapter() {
        if (this.categoryItemProvider == null) {
            this.categoryItemProvider = new CategoryItemProvider((AdapterFactory)this);
        }
        return this.categoryItemProvider;
    }

    public Adapter createModelAutoCreateAdapter() {
        if (this.modelAutoCreateItemProvider == null) {
            this.modelAutoCreateItemProvider = new ModelAutoCreateItemProvider((AdapterFactory)this);
        }
        return this.modelAutoCreateItemProvider;
    }

    public Adapter createRootAutoSelectAdapter() {
        if (this.rootAutoSelectItemProvider == null) {
            this.rootAutoSelectItemProvider = new RootAutoSelectItemProvider((AdapterFactory)this);
        }
        return this.rootAutoSelectItemProvider;
    }

    public Adapter createAssistantRuleAdapter() {
        if (this.assistantRuleItemProvider == null) {
            this.assistantRuleItemProvider = new AssistantRuleItemProvider((AdapterFactory)this);
        }
        return this.assistantRuleItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.papyrusConfigurationItemProvider != null) {
            this.papyrusConfigurationItemProvider.dispose();
        }
        if (this.papyrusViewpointItemProvider != null) {
            this.papyrusViewpointItemProvider.dispose();
        }
        if (this.papyrusViewItemProvider != null) {
            this.papyrusViewItemProvider.dispose();
        }
        if (this.papyrusDiagramItemProvider != null) {
            this.papyrusDiagramItemProvider.dispose();
        }
        if (this.papyrusSyncTableItemProvider != null) {
            this.papyrusSyncTableItemProvider.dispose();
        }
        if (this.papyrusTableItemProvider != null) {
            this.papyrusTableItemProvider.dispose();
        }
        if (this.modelRuleItemProvider != null) {
            this.modelRuleItemProvider.dispose();
        }
        if (this.owningRuleItemProvider != null) {
            this.owningRuleItemProvider.dispose();
        }
        if (this.childRuleItemProvider != null) {
            this.childRuleItemProvider.dispose();
        }
        if (this.paletteRuleItemProvider != null) {
            this.paletteRuleItemProvider.dispose();
        }
        if (this.pathElementItemProvider != null) {
            this.pathElementItemProvider.dispose();
        }
        if (this.categoryItemProvider != null) {
            this.categoryItemProvider.dispose();
        }
        if (this.modelAutoCreateItemProvider != null) {
            this.modelAutoCreateItemProvider.dispose();
        }
        if (this.rootAutoSelectItemProvider != null) {
            this.rootAutoSelectItemProvider.dispose();
        }
        if (this.assistantRuleItemProvider != null) {
            this.assistantRuleItemProvider.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iso42010ChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return ConfigurationEditPlugin.INSTANCE;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CreationSwitch
        extends Iso42010Switch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseArchitectureDescription(ArchitectureDescription object) {
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_DESCRIPTION__VIEWPOINTS, ConfigurationFactory.eINSTANCE.createPapyrusViewpoint()));
                return null;
            }

            public Object caseArchitectureViewpoint(ArchitectureViewpoint object) {
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_VIEWPOINT__MODEL_KINDS, ConfigurationFactory.eINSTANCE.createPapyrusView()));
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_VIEWPOINT__MODEL_KINDS, ConfigurationFactory.eINSTANCE.createPapyrusDiagram()));
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_VIEWPOINT__MODEL_KINDS, ConfigurationFactory.eINSTANCE.createPapyrusSyncTable()));
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_VIEWPOINT__MODEL_KINDS, ConfigurationFactory.eINSTANCE.createPapyrusTable()));
                return null;
            }

            public Object caseArchitectureFramework(ArchitectureFramework object) {
                this.newChildDescriptors.add(this.createChildParameter(Iso42010Package.Literals.ARCHITECTURE_FRAMEWORK__VIEWPOINTS, ConfigurationFactory.eINSTANCE.createPapyrusViewpoint()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }
}

