/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.utilities;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.ExplicitNavigationProperty;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

class UMLRedefinedNavigationProperty
extends ExplicitNavigationProperty {
    protected final @NonNull Property baseProperty;

    public UMLRedefinedNavigationProperty(@NonNull CompleteModel completeModel, @NonNull Property property) {
        super(property);
        CompleteClass baseCompleteClass = completeModel.getCompleteClass((Type)property.getOwningClass());
        Property baseProperty = property;
        for (Property aProperty : property.getRedefinedProperties()) {
            CompleteClass aCompleteClass = completeModel.getCompleteClass((Type)aProperty.getOwningClass());
            if (!baseCompleteClass.conformsTo(aCompleteClass)) continue;
            baseCompleteClass = aCompleteClass;
            baseProperty = aProperty;
        }
        this.baseProperty = baseProperty;
    }

    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        Object unredefinedResult = super.evaluate(executor, returnTypeId, sourceValue);
        Type unredefinedType = this.baseProperty.getType();
        Type redefinedType = this.property.getType();
        if (unredefinedType instanceof CollectionType) {
            if (!(redefinedType instanceof CollectionType)) {
                CollectionValue asCollectionValue = ValueUtil.asCollectionValue((Object)unredefinedResult);
                int intSize = asCollectionValue.intSize();
                switch (intSize) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return asCollectionValue.getElements().iterator().next();
                    }
                }
                throw new InvalidValueException("Too many values for redefined ''{0}''", new Object[]{this.property});
            }
            return unredefinedResult;
        }
        if (redefinedType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)redefinedType;
            CollectionTypeId typeId = collectionType.getTypeId();
            List<Object> valueAsList = Collections.singletonList(unredefinedResult);
            return executor.getIdResolver().createCollectionOfAll(typeId, valueAsList);
        }
        return unredefinedResult;
    }
}

