/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.executors;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.opencert.storage.cdo.session.ICDOSessionProvider;

public abstract class SessionNotClosingInTransactionExecutor {
    private final ICDOSessionProvider cdoSessionProvider;

    public abstract void executeInTransaction(CDOTransaction var1);

    public SessionNotClosingInTransactionExecutor(ICDOSessionProvider cdoSessionProvider) {
        this.cdoSessionProvider = cdoSessionProvider;
    }

    public void executeReadOnlyOperation() {
        CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
        CDOTransaction cdoTransaction = activeSession.openTransaction();
        this.executeInTransaction(cdoTransaction);
        cdoTransaction.rollback();
    }

    public void executeReadWriteOperation() {
        CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
        CDOTransaction cdoTransaction = activeSession.openTransaction();
        this.executeInTransaction(cdoTransaction);
        try {
            cdoTransaction.commit();
        }
        catch (CommitException e) {
            throw new RuntimeException(e);
        }
    }
}

