/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.runtime;

import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.CompoundConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class ConstraintFactory {
    private static ConstraintFactory instance = new ConstraintFactory();

    private ConstraintFactory() {
    }

    public static ConstraintFactory getInstance() {
        return instance;
    }

    public Constraint createFromModel(ConstraintDescriptor model) {
        Constraint constraint = null;
        if (model instanceof CompositeConstraint) {
            CompoundConstraint cConstraint = new CompoundConstraint();
            cConstraint.setConstraintDescriptor(model);
            for (SimpleConstraint descriptor : ((CompositeConstraint)model).getConstraints()) {
                Constraint subConstraint = this.loadConstraint(descriptor);
                if (subConstraint == null) {
                    Activator.log.warn("Cannot load constraint " + model.getName());
                    return null;
                }
                cConstraint.addConstraint(subConstraint);
            }
            constraint = cConstraint;
        } else {
            constraint = this.loadConstraint((SimpleConstraint)model);
        }
        return constraint;
    }

    private Constraint loadConstraint(SimpleConstraint model) {
        Constraint constraint = null;
        if (model.getConstraintType() != null) {
            String className = model.getConstraintType().getConstraintClass();
            constraint = (Constraint)ClassLoaderHelper.newInstance((String)className, Constraint.class);
        }
        if (constraint == null) {
            Activator.log.warn("Cannot load constraint " + model.getName());
            return null;
        }
        constraint.setConstraintDescriptor(model);
        return constraint;
    }
}

