/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.core.importer.IModelImportMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelImporter;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.controlmode.CDOControlModeParticipant;
import org.eclipse.papyrus.cdo.internal.core.importer.DependencyAdapter;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.core.resource.CDOSashModelProvider;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageList;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ModelImporter
implements IModelImporter {
    protected static final ContentType DI_CONTENT = new ContentType("DI");
    protected static final ContentType UML_CONTENT = new ContentType("UML");
    protected static final ContentType NOTATION_CONTENT = new ContentType("Notation");
    protected static final ContentType UNKNOWN_CONTENT = new ContentType("unknown");

    @Override
    public Diagnostic importModels(final IModelImportMapping mapping) {
        BasicDiagnostic result = new BasicDiagnostic();
        ModelImporter.add((DiagnosticChain)result, mapping.getConfiguration().validate());
        ModelImporter.add((DiagnosticChain)result, mapping.validate());
        if (result.getSeverity() < 4) {
            ModelImporter.add((DiagnosticChain)result, mapping.getConfiguration().getOperationContext().run(new IModelTransferOperation(){

                @Override
                public Diagnostic run(IProgressMonitor monitor) {
                    return ModelImporter.this.doImport(mapping, monitor);
                }
            }));
        }
        return result;
    }

    protected Diagnostic doImport(IModelImportMapping mapping, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IModelTransferConfiguration configuration = mapping.getConfiguration();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelImporter_4, (int)(configuration.getModelsToTransfer().size() + 4));
        CDOCheckout checkout = mapping.getCheckout();
        CDOTransaction transaction = checkout.openTransaction((ResourceSet)new ResourceSetImpl());
        ResourceSet destination = transaction.getResourceSet();
        try {
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelImporter.add((DiagnosticChain)result, this.importModel(model, configuration.getResourceSet(), mapping.getMapping(model), transaction, (IProgressMonitor)sub.newChild(1)));
            }
            try {
                transaction.commit((IProgressMonitor)sub.newChild(1));
                for (Resource next : destination.getResources()) {
                    if (!DependencyAdapter.isDIResource(next) || CDOUtils.isCDOURI(next.getURI())) continue;
                    next.save(null);
                }
            }
            catch (Exception e) {
                result.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelImporter_5, new Object[]{e}));
            }
            boolean hasSubUnits = false;
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                if (!this.createSubUnitProxies(model, mapping.getMapping(model), transaction, (IProgressMonitor)sub.newChild(1))) continue;
                hasSubUnits = true;
            }
            if (hasSubUnits) {
                try {
                    transaction.commit((IProgressMonitor)sub.newChild(1));
                }
                catch (CommitException e) {
                    result.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelImporter_5, new Object[]{e}));
                }
            } else {
                sub.worked(1);
            }
            try {
                this.saveNonimportedModels(mapping, transaction, (IProgressMonitor)sub.newChild(1));
            }
            catch (Exception e) {
                result.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelImporter_6, new Object[]{e}));
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)configuration.getResourceSet());
            CDOUtils.unload((CDOView)transaction);
            transaction.close();
            EMFHelper.unload((ResourceSet)destination);
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic importModel(IModelTransferNode model, ResourceSet rset, IPath toPath, CDOTransaction transaction, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IPath basePath = toPath.removeFileExtension();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)model.getName(), (int)model.getResourceURIs().size());
        for (URI next : model.getResourceURIs()) {
            CDOResource destination = transaction.getOrCreateResource(basePath.addFileExtension(next.fileExtension()).toString());
            Resource source = rset.getResource(next, true);
            if (model.getConfiguration().isStripSashModelContent() && DependencyAdapter.isDIResource(source)) {
                Resource sashResource;
                CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)transaction);
                URI sashURI = new CDOSashModelProvider().initialize(checkout).getSashModelURI(destination.getURI());
                ResourceSet dset = destination.getResourceSet();
                Resource resource = sashResource = dset.getURIConverter().exists(sashURI, null) ? dset.getResource(sashURI, true) : null;
                if (sashResource == null) {
                    sashResource = dset.createResource(sashURI);
                }
                destination = sashResource;
            }
            ModelImporter.add((DiagnosticChain)result, this.importResource(source, (Resource)destination));
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected boolean createSubUnitProxies(IModelTransferNode model, IPath toPath, CDOTransaction transaction, IProgressMonitor monitor) {
        IPath basePath = toPath.removeFileExtension();
        URI uri = model.getPrimaryResourceURI();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)model.getName(), (int)1);
        CDOResource destination = transaction.getResource(basePath.addFileExtension(uri.fileExtension()).toString());
        CDOControlModeParticipant.IUpdate update = new CDOControlModeParticipant().getProxyCrossReferencesUpdate((Resource)destination);
        boolean result = !update.isEmpty();
        update.apply();
        sub.worked(1);
        sub.done();
        return result;
    }

    protected Diagnostic importResource(Resource source, Resource destination) {
        if (!destination.getContents().isEmpty()) {
            ContentType contentType = this.getContentType(source);
            if (contentType == DI_CONTENT) {
                this.mergeDIContent(source, destination);
            } else {
                destination.getContents().addAll((Collection)source.getContents());
            }
        } else {
            destination.getContents().addAll((Collection)source.getContents());
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected ContentType getContentType(Resource resource) {
        ContentType result = UNKNOWN_CONTENT;
        for (EObject next : resource.getContents()) {
            EPackage ePackage = next.eClass().getEPackage();
            if (ePackage == DiPackage.eINSTANCE) {
                result = DI_CONTENT;
                break;
            }
            if (ePackage.getName().equalsIgnoreCase("uml")) {
                result = UML_CONTENT;
                break;
            }
            if (!ePackage.getName().equalsIgnoreCase("notation")) continue;
            result = NOTATION_CONTENT;
            break;
        }
        return result;
    }

    protected void mergeDIContent(Resource source, Resource destination) {
        SashWindowsMngr srcMngr = DiUtils.lookupSashWindowsMngr((Resource)source);
        EcoreUtil.remove((EObject)srcMngr);
        SashWindowsMngr dstMngr = DiUtils.lookupSashWindowsMngr((Resource)destination);
        if (dstMngr == null) {
            destination.getContents().add(0, (Object)srcMngr);
        } else {
            SashModel dstModel = dstMngr.getSashModel();
            SashModel srcModel = srcMngr.getSashModel();
            if (dstModel == null) {
                dstMngr.setSashModel(srcModel);
            } else {
                dstModel.getWindows().addAll((Collection)srcModel.getWindows());
                if (dstModel.getCurrentSelection() == null) {
                    dstModel.setCurrentSelection(srcModel.getCurrentSelection());
                }
            }
            PageList dstPages = dstMngr.getPageList();
            PageList srcPages = srcMngr.getPageList();
            if (dstPages == null) {
                dstMngr.setPageList(srcPages);
            } else {
                dstPages.getAvailablePage().addAll((Collection)srcPages.getAvailablePage());
            }
        }
        destination.getContents().addAll((Collection)source.getContents());
    }

    protected Diagnostic saveNonimportedModels(IModelImportMapping mapping, CDOTransaction transaction, IProgressMonitor monitor) {
        IModelTransferConfiguration configuration = mapping.getConfiguration();
        BasicDiagnostic result = new BasicDiagnostic();
        Collection<IModelTransferNode> imported = configuration.getModelsToTransfer();
        HashSet nonImported = Sets.newHashSet();
        for (IModelTransferNode next : configuration.getModelsToTransfer()) {
            for (IModelTransferNode dependent : next.getDependents()) {
                if (imported.contains(dependent)) continue;
                nonImported.add(dependent);
            }
        }
        if (!nonImported.isEmpty()) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelImporter_9, (int)nonImported.size());
            ResourceSet rset = configuration.getResourceSet();
            try {
                for (IModelTransferNode next : nonImported) {
                    for (URI uri : next.getResourceURIs()) {
                        Resource resource = rset.getResource(uri, false);
                        if (resource == null || resource.isModified()) continue;
                        try {
                            resource.save(null);
                        }
                        catch (Exception e) {
                            ModelImporter.add((DiagnosticChain)result, (Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelImporter_10, new Object[]{e}));
                        }
                    }
                    sub.worked(1);
                }
            }
            finally {
                sub.done();
            }
        }
        return result;
    }

    private static void add(DiagnosticChain diagnostics, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() > 0) {
            diagnostics.merge(diagnostic);
        }
    }

    protected static class ContentType {
        private final String name;

        protected ContentType(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ContentType && ((ContentType)obj).getName().equals(this.getName());
        }

        public String toString() {
            return String.valueOf(this.getName()) + " content";
        }
    }
}

