/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.deps;

import java.util.EnumSet;
import java.util.Set;

public enum RpmDependencyFlags {
    LESS(1),
    GREATER(2),
    EQUAL(3),
    PREREQ(6),
    PRETRANS(7),
    INTERPRETER(8),
    SCRIPT_PRE(9),
    SCRIPT_POST(10),
    SCRIPT_PREUN(11),
    SCRIPT_POSTUN(12),
    SCRIPT_VERIFY(13),
    FIND_REQUIRES(14),
    FIND_PROVIDES(15),
    TRIGGER_IN(16),
    TRIGGER_UN(17),
    TRIGGER_POSTUN(18),
    MISSINGOK(19),
    RPMLIB(24),
    TRIGGER_PREIN(25),
    KEYRING(26),
    CONFIG(28);

    private int value;

    private RpmDependencyFlags(int bit) {
        this.value = 1 << bit;
    }

    public static int encode(Set<RpmDependencyFlags> flags) {
        int value = 0;
        for (RpmDependencyFlags flag : flags) {
            value |= flag.value;
        }
        return value;
    }

    public static EnumSet<RpmDependencyFlags> parse(Long flags) {
        if (flags == null) {
            return null;
        }
        return RpmDependencyFlags.parse(flags.intValue());
    }

    public static EnumSet<RpmDependencyFlags> parse(int flags) {
        EnumSet<RpmDependencyFlags> result = EnumSet.noneOf(RpmDependencyFlags.class);
        RpmDependencyFlags[] rpmDependencyFlagsArray = RpmDependencyFlags.values();
        int n = rpmDependencyFlagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RpmDependencyFlags f = rpmDependencyFlagsArray[n2];
            if ((flags & f.value) > 0) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }
}

