/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.str;

import java.util.Map;
import org.eclipse.scada.utils.str.StringReplacer;

public class ExtendedPropertiesReplacer
implements StringReplacer.ReplaceSource {
    private final Map<?, ?> properties;
    private final boolean failOnMissingKey;

    public ExtendedPropertiesReplacer(Map<?, ?> properties, boolean failOnMissingKey) {
        this.properties = properties;
        this.failOnMissingKey = failOnMissingKey;
    }

    public ExtendedPropertiesReplacer(Map<?, ?> properties) {
        this(properties, false);
    }

    @Override
    public String replace(String context, String key) {
        String name = key;
        String op = null;
        String arg = null;
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (c == ':') {
                name = key.substring(0, i);
                op = Character.toString(c);
                if (i + 1 < key.length()) {
                    arg = key.substring(i + 1, key.length());
                    break;
                }
                arg = null;
                break;
            }
            ++i;
        }
        String value = this.getValue(name);
        if (op == null || op.equals("")) {
            if (value == null && this.failOnMissingKey) {
                throw new IllegalStateException(String.format("Key '%s' not found", context));
            }
            return value == null ? context : value;
        }
        if (op.equals(":")) {
            return value == null ? arg : value;
        }
        if (this.failOnMissingKey) {
            throw new IllegalStateException(String.format("Unable to replace '%s'", context));
        }
        return context;
    }

    private String getValue(String name) {
        Object v = this.properties.get(name);
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

