/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.channel.impl.ProviderListener;
import org.eclipse.packagedrone.repo.channel.provider.ChannelProvider;
import org.eclipse.packagedrone.utils.Locks;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ChannelProviderTracker {
    private Lock readLock;
    private Lock writeLock;
    private ServiceTracker<ChannelProvider, ChannelProvider> tracker;
    private final Map<String, ChannelProvider> providers = new HashMap<String, ChannelProvider>();
    private final Multimap<String, ProviderListener> listeners = HashMultimap.create();

    public ChannelProviderTracker(final BundleContext context) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.tracker = new ServiceTracker(context, ChannelProvider.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ChannelProvider, ChannelProvider>(){

            public ChannelProvider addingService(ServiceReference<ChannelProvider> reference) {
                ChannelProvider service = (ChannelProvider)context.getService(reference);
                ChannelProviderTracker.this.addService(service);
                return service;
            }

            public void modifiedService(ServiceReference<ChannelProvider> reference, ChannelProvider service) {
            }

            public void removedService(ServiceReference<ChannelProvider> reference, ChannelProvider service) {
                try {
                    ChannelProviderTracker.this.removeService(service);
                }
                finally {
                    context.ungetService(reference);
                }
            }
        });
    }

    protected void addService(ChannelProvider service) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.providers.put(service.getId(), service);
            for (ProviderListener listener : this.listeners.get((Object)service.getId())) {
                listener.bind(service);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void removeService(ChannelProvider service) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.providers.remove(service.getId());
            for (ProviderListener listener : this.listeners.get((Object)service.getId())) {
                listener.unbind();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addListener(String providerId, ProviderListener listener) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.listeners.put((Object)providerId, (Object)listener);
            ChannelProvider provider = this.providers.get(providerId);
            if (provider != null) {
                listener.bind(provider);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void removeListener(String providerId, ProviderListener listener) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.listeners.remove((Object)providerId, (Object)listener);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void run(String id, Consumer<Optional<ChannelProvider>> run) {
        Objects.requireNonNull(run);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            run.accept(Optional.ofNullable(this.providers.get(id)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <R> R call(String id, Function<Optional<ChannelProvider>, R> call) {
        Objects.requireNonNull(call);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            return call.apply(Optional.ofNullable(this.providers.get(id)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }
}

