/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.packagedrone.repo.channel.Validated;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;

public class ChannelState
implements Validated {
    private long numberOfArtifacts;
    private long numberOfBytes;
    private boolean locked;
    private Instant creationTimestamp;
    private Instant modificationTimestamp;
    private List<ValidationMessage> messages = Collections.emptyList();

    private ChannelState() {
    }

    private ChannelState(ChannelState other) {
        this.messages = other.messages;
        this.numberOfArtifacts = other.numberOfArtifacts;
        this.numberOfBytes = other.numberOfBytes;
        this.locked = other.locked;
        this.creationTimestamp = other.creationTimestamp;
        this.modificationTimestamp = other.modificationTimestamp;
    }

    public long getNumberOfArtifacts() {
        return this.numberOfArtifacts;
    }

    public long getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Instant getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant getModificationTimestamp() {
        return this.modificationTimestamp;
    }

    @Override
    public Collection<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    /* synthetic */ ChannelState(ChannelState channelState, ChannelState channelState2) {
        this();
    }

    /* synthetic */ ChannelState(ChannelState channelState, ChannelState channelState2, ChannelState channelState3) {
        this(channelState);
    }

    public static class Builder {
        private ChannelState value;
        private boolean needFork;

        public Builder() {
            this.value = new ChannelState(null, null);
            Instant instant = Instant.now();
            this.value.modificationTimestamp = instant;
            this.value.creationTimestamp = instant;
        }

        public Builder(ChannelState other) {
            ChannelState channelState = this.value = other != null ? new ChannelState(other, null, null) : new ChannelState(null, null);
            if (this.value.creationTimestamp == null) {
                this.value.creationTimestamp = Instant.now();
            }
            if (this.value.modificationTimestamp == null) {
                this.value.modificationTimestamp = Instant.now();
            }
        }

        public void setCreationTimestamp(Instant creationTimestamp) {
            this.checkFork();
            this.value.creationTimestamp = creationTimestamp;
        }

        public void setModificationTimestamp(Instant modificationTimestamp) {
            this.checkFork();
            this.value.modificationTimestamp = modificationTimestamp;
        }

        public void setNumberOfArtifacts(long numberOfArtifacts) {
            this.checkFork();
            this.value.numberOfArtifacts = numberOfArtifacts;
        }

        public void setNumberOfBytes(long numberOfBytes) {
            this.checkFork();
            this.value.numberOfBytes = numberOfBytes;
        }

        public void incrementNumberOfBytes(long numberOfBytes) {
            this.checkFork();
            ChannelState channelState = this.value;
            channelState.numberOfBytes = channelState.numberOfBytes + numberOfBytes;
        }

        public void setLocked(boolean locked) {
            this.checkFork();
            this.value.locked = locked;
        }

        public void setValidationMessages(List<ValidationMessage> messages) {
            this.checkFork();
            this.value.messages = Collections.unmodifiableList(new CopyOnWriteArrayList<ValidationMessage>(messages));
        }

        private void checkFork() {
            if (this.needFork) {
                this.needFork = false;
                this.value = new ChannelState(this.value, null, null);
            }
        }

        public ChannelState build() {
            this.needFork = true;
            return this.value;
        }
    }
}

