/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractWriter {
    protected static final char NL = '\n';
    protected static final String IN = "  ";
    protected static final String IN2 = "    ";
    private final String basename;
    private final String title;
    private final String type;
    private final boolean compressed;
    private final Map<String, String> properties;

    public AbstractWriter(String basename, String title, String type, Instant timestamp, boolean compressed, Map<String, String> additionalProperties) {
        this.basename = basename;
        this.title = title;
        this.type = type;
        this.compressed = compressed;
        this.properties = new LinkedHashMap<String, String>();
        if (compressed) {
            this.properties.put("p2.compressed", "true");
        }
        this.properties.put("p2.timestamp", Long.toString(timestamp.toEpochMilli()));
        if (additionalProperties != null) {
            this.properties.putAll(additionalProperties);
        }
    }

    public String getId() {
        return String.valueOf(this.basename) + (this.compressed ? ".jar" : ".xml");
    }

    public String getMimeType() {
        return this.compressed ? "application/zip" : "application/xml";
    }

    public void write(OutputStream stream) throws IOException {
        if (this.compressed) {
            ZipOutputStream zos = new ZipOutputStream(stream);
            zos.putNextEntry(new ZipEntry(String.valueOf(this.basename) + ".xml"));
            this.writeAll(zos);
            zos.closeEntry();
            zos.finish();
        } else {
            this.writeAll(stream);
        }
    }

    private void writeAll(OutputStream stream) throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        this.writeHeader(out);
        this.writeContent(out);
        this.writeFooter(out);
        out.flush();
    }

    protected void writeHeader(PrintWriter out) throws IOException {
        out.append("<?xml version='1.0' encoding='UTF-8'?>").append('\n');
        out.append("<?metadataRepository version='1.1.0'?>").append('\n');
        out.format("<repository name='%s' type='%s' version='1'>", XmlEscapers.xmlAttributeEscaper().escape(this.title), XmlEscapers.xmlAttributeEscaper().escape(this.type)).append('\n');
        if (!this.properties.isEmpty()) {
            out.append(IN).format("<properties size='%s'>", this.properties.size()).append('\n');
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                out.append(IN2).format("<property name='%s' value='%s'/>", XmlEscapers.xmlAttributeEscaper().escape(entry.getKey()), XmlEscapers.xmlAttributeEscaper().escape(entry.getValue())).append('\n');
            }
            out.append(IN).append("</properties>").append('\n');
        }
    }

    protected abstract void writeContent(PrintWriter var1) throws IOException;

    protected void writeFooter(PrintWriter out) throws IOException {
        out.append("</repository>").append('\n');
    }
}

