/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.controller.ControllerBinder;
import org.eclipse.packagedrone.web.controller.ControllerBinderParametersAware;
import org.eclipse.packagedrone.web.controller.ControllerInterceptorProcessor;
import org.eclipse.packagedrone.web.controller.JaxRsResponseHandler;
import org.eclipse.packagedrone.web.controller.ModelAndViewRequestHandler;
import org.eclipse.packagedrone.web.controller.NoOpRequestHandler;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.ErrorBinder;
import org.eclipse.packagedrone.web.controller.binding.PathVariableBinder;
import org.eclipse.packagedrone.web.controller.binding.RequestParameterBinder;
import org.eclipse.packagedrone.web.controller.form.FormDataBinder;
import org.eclipse.packagedrone.web.controller.routing.RequestMappingInformation;

public class ControllerCall {
    private final RequestMappingInformation rmi;
    private final Method m;
    private final ControllerInterceptorProcessor[] interceptors;
    private final Object controller;

    public ControllerCall(Object controller, RequestMappingInformation rmi, Method m, Set<ControllerInterceptorProcessor> interceptors) {
        this.controller = controller;
        this.rmi = rmi;
        this.m = m;
        this.interceptors = interceptors.toArray(new ControllerInterceptorProcessor[interceptors.size()]);
    }

    public RequestMappingInformation.Match matches(HttpServletRequest request) {
        return this.rmi.matches(request);
    }

    protected RequestHandler runForward(int index, HttpServletRequest request, HttpServletResponse response, Callable<RequestHandler> last) throws Exception {
        if (index < this.interceptors.length) {
            return this.interceptors[index].before(this.controller, this.m, request, response, (chainReq, chainRes) -> {
                try {
                    return this.runForward(index + 1, (HttpServletRequest)chainReq, (HttpServletResponse)chainRes, last);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return last.call();
    }

    protected RequestHandler runBackward(int index, HttpServletRequest request, HttpServletResponse response, Callable<RequestHandler> last) throws Exception {
        if (index > 0) {
            return this.interceptors[index - 1].after(this.controller, this.m, request, response, (chainReq, chainRes) -> {
                try {
                    return this.runBackward(index - 1, (HttpServletRequest)chainReq, (HttpServletResponse)chainRes, last);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return last.call();
    }

    public RequestHandler call(RequestMappingInformation.Match match, HttpServletRequest request, HttpServletResponse response) {
        try {
            final RequestHandler result = this.runForward(0, request, response, () -> this.processCall(match, request, response));
            return this.runBackward(this.interceptors.length, request, response, new Callable<RequestHandler>(){

                @Override
                public RequestHandler call() throws Exception {
                    return result;
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected RequestHandler processCall(RequestMappingInformation.Match match, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("request", request);
        data.put("response", response);
        data.put("session", request.getSession());
        data.put("principal", request.getUserPrincipal());
        BindingManager manager = BindingManager.create(data);
        manager.addBinder(new RequestParameterBinder(request));
        manager.addBinder(new PathVariableBinder(match));
        manager.addBinder(new FormDataBinder(request, this.controller));
        ControllerCall.addMethodBinders(manager, this.m);
        BindingManager.Call call = manager.bind(this.m, this.controller);
        Object result = call.invoke();
        if (result instanceof ModelAndView) {
            return new ModelAndViewRequestHandler((ModelAndView)result, this.controller.getClass(), this.m);
        }
        if (result instanceof String) {
            return new ModelAndViewRequestHandler(new ModelAndView((String)result), this.controller.getClass(), this.m);
        }
        if (result == null) {
            return new NoOpRequestHandler();
        }
        if (result instanceof Response) {
            return new JaxRsResponseHandler((Response)result);
        }
        throw new IllegalStateException(String.format("Response type %s is unsupported", result.getClass()));
    }

    protected static void addMethodBinders(BindingManager manager, Method method) {
        ControllerBinder[] binders = (ControllerBinder[])method.getAnnotationsByType(ControllerBinder.class);
        if (binders == null) {
            return;
        }
        ControllerBinder[] controllerBinderArray = binders;
        int n = binders.length;
        int n2 = 0;
        while (n2 < n) {
            ControllerBinder binder = controllerBinderArray[n2];
            try {
                Binder binderImpl = binder.value().newInstance();
                if (binderImpl instanceof ControllerBinderParametersAware) {
                    ((ControllerBinderParametersAware)((Object)binderImpl)).setParameters(binder.parameters());
                }
                manager.addBinder(binderImpl);
            }
            catch (IllegalAccessException | InstantiationException e) {
                manager.addBinder(new ErrorBinder(e));
            }
            ++n2;
        }
    }
}

