/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.trigger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModel;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModelAccess;
import org.eclipse.packagedrone.repo.channel.impl.trigger.ConfiguredTriggerContext;
import org.eclipse.packagedrone.repo.channel.impl.trigger.TriggeredChannelModel;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.TriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessor;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessorConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessorState;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.utils.Holder;

public final class TriggeredChannelImpl
implements TriggeredChannel {
    private static final String CONFIG_KEY = "triggers";
    private final ChannelId id;
    private final ChannelInstanceModel channelModel;
    private final ProcessorFactoryTracker processorFactoryTracker;
    private final Map<String, TriggerDescriptor> predefined;
    private final TriggeredChannelModel model;
    private boolean modified;
    private final ConfiguredTriggerContext configuredContext;

    public TriggeredChannelImpl(ChannelId id, ChannelInstanceModel channelModel, ProcessorFactoryTracker processorFactoryTracker, Map<String, TriggerDescriptor> predefined, ConfiguredTriggerContext configuredContext) {
        this.id = id;
        this.channelModel = channelModel;
        this.processorFactoryTracker = processorFactoryTracker;
        this.predefined = predefined;
        this.configuredContext = configuredContext;
        this.model = TriggeredChannelImpl.loadConfiguration(channelModel);
    }

    private static Gson createGson() {
        GsonBuilder gb = new GsonBuilder();
        return gb.create();
    }

    public static TriggeredChannelModel loadConfiguration(String cfg) {
        return (TriggeredChannelModel)TriggeredChannelImpl.createGson().fromJson(cfg, TriggeredChannelModel.class);
    }

    public static TriggeredChannelModel loadConfiguration(ChannelInstanceModelAccess model) {
        Objects.requireNonNull(model);
        String cfg = model.getConfigurations().get(CONFIG_KEY);
        if (cfg != null) {
            return TriggeredChannelImpl.loadConfiguration(cfg);
        }
        return new TriggeredChannelModel();
    }

    public void flush() {
        if (this.modified) {
            this.channelModel.put(CONFIG_KEY, TriggeredChannelImpl.createGson().toJson((Object)this.model));
        }
    }

    public ChannelId getId() {
        return this.id;
    }

    public Collection<TriggerHandle> listTriggers() {
        LinkedHashSet<String> triggers = new LinkedHashSet<String>();
        triggers.addAll(this.predefined.keySet());
        triggers.addAll(this.model.getTriggers());
        ArrayList<TriggerHandle> result = new ArrayList<TriggerHandle>(triggers.size());
        for (String triggerId : triggers) {
            TriggerHandle handle = this.makeHandle(triggerId);
            result.add(handle);
        }
        return result;
    }

    public Optional<TriggerHandle> getTrigger(String triggerId) {
        if (triggerId == null) {
            return Optional.empty();
        }
        if (this.predefined.containsKey(triggerId) || this.model.getTriggers().contains(triggerId)) {
            return Optional.of(this.makeHandle(triggerId));
        }
        return Optional.empty();
    }

    private TriggerHandle makeHandle(final String triggerId) {
        final Optional<TriggerDescriptor> descriptor = Optional.ofNullable(this.findDescriptor(triggerId));
        List<TriggerProcessorConfiguration> processorConfigurations = this.model.getProcessors(triggerId);
        final Optional<TriggerConfiguration> configuration = this.model.getTriggerConfiguration(triggerId);
        final List processors = processorConfigurations.stream().map(this::mapProcessor).collect(Collectors.toList());
        return new TriggerHandle(){

            public List<TriggerProcessor> getProcessors() {
                return processors;
            }

            public String getId() {
                return triggerId;
            }

            public Optional<TriggerDescriptor> getDescriptor() {
                return descriptor;
            }

            public Optional<TriggerConfiguration> getConfiguration() {
                return configuration;
            }

            public TriggerHandle reorderProcessors(String processorId1, String processorId2) throws IllegalArgumentException {
                TriggeredChannelImpl.this.reorderProcessors(triggerId, processorId1, processorId2);
                return TriggeredChannelImpl.this.makeHandle(triggerId);
            }
        };
    }

    private TriggerDescriptor findDescriptor(String triggerId) {
        TriggerDescriptor result = this.predefined.get(triggerId);
        if (result != null) {
            return result;
        }
        return this.configuredContext.get(triggerId);
    }

    private TriggerProcessor mapProcessor(TriggerProcessorConfiguration cfg) {
        Holder result = new Holder();
        this.processorFactoryTracker.processOptionally(cfg.getFactoryId(), factory -> {
            holder.value = factory.map(value -> value.validate(cfg.getConfiguration()));
        });
        return new TriggerProcessor(cfg, (Optional)result.value);
    }

    public TriggerHandle addConfiguredTrigger(String triggerFactoryId, String configuration) {
        Objects.requireNonNull(triggerFactoryId);
        String triggerId = UUID.randomUUID().toString();
        TriggerConfiguration cfg = new TriggerConfiguration(triggerFactoryId, configuration);
        this.model.addTrigger(triggerId, cfg);
        this.configuredContext.add(triggerId, cfg);
        this.modified = true;
        return this.makeHandle(triggerId);
    }

    public void modifyConfiguredTrigger(String triggerConfigurationId, String configuration) {
        Objects.requireNonNull(triggerConfigurationId);
        this.model.modifyTrigger(triggerConfigurationId, configuration);
        this.configuredContext.modify(triggerConfigurationId, configuration);
        this.modified = true;
    }

    public void deleteConfiguredTrigger(String triggerConfigurationId) {
        Objects.requireNonNull(triggerConfigurationId);
        this.model.deleteTrigger(triggerConfigurationId);
        this.configuredContext.dispose(triggerConfigurationId);
        this.modified = true;
    }

    public TriggerProcessorConfiguration addProcessor(String triggerId, String processorFactoryId, String configuration) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(processorFactoryId);
        TriggerProcessorConfiguration result = new TriggerProcessorConfiguration(UUID.randomUUID().toString(), processorFactoryId, configuration);
        this.model.addProcessor(triggerId, result);
        this.modified = true;
        return result;
    }

    public void modifyProcessor(String triggerId, String processorId, String configuration) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(processorId);
        this.model.modifyProcessor(triggerId, processorId, configuration);
        this.modified = true;
    }

    public void deleteProcessor(String triggerId, String processorId) {
        Objects.requireNonNull(triggerId);
        Objects.requireNonNull(processorId);
        this.model.deleteProcessor(triggerId, processorId);
        this.modified = true;
    }

    private void reorderProcessors(String triggerId, String processorId1, String processorId2) {
        this.model.reorderProcessors(triggerId, processorId1, processorId2);
        this.modified = true;
    }

    public void reorder(String triggerId1, String processorId1, String triggerId2, String processorId2) {
        Objects.requireNonNull(triggerId1);
        Objects.requireNonNull(triggerId2);
        Objects.requireNonNull(processorId1);
        if (triggerId1.equals(triggerId2)) {
            this.reorderProcessors(triggerId1, processorId1, processorId2);
        } else {
            Optional<TriggerHandle> t1 = this.getTrigger(triggerId1);
            Optional<TriggerHandle> t2 = this.getTrigger(triggerId2);
            if (!t1.isPresent()) {
                throw new IllegalArgumentException(String.format("Unable to find trigger '%s'", triggerId1));
            }
            if (!t2.isPresent()) {
                throw new IllegalArgumentException(String.format("Unable to find trigger '%s'", triggerId2));
            }
            if (!this.isCompatible(t2.get(), (TriggerProcessor)t1.get().getProcessor(processorId1).orElseThrow(this.unknownProcessor(triggerId1, processorId1)))) {
                throw new IllegalArgumentException(String.format("Processor '%s' is not compatible with trigger '%s'", processorId1, triggerId2));
            }
            this.model.moveProcessor(triggerId1, processorId1, triggerId2, processorId2);
            this.modified = true;
        }
    }

    private Supplier<? extends IllegalArgumentException> unknownProcessor(String triggerId, String processorId) {
        return () -> new IllegalArgumentException(String.format("Unable to find processor %s of trigger %s", processorId, triggerId));
    }

    private boolean isCompatible(TriggerHandle triggerHandle, TriggerProcessor triggerProcessor) {
        TriggerDescriptor desc = (TriggerDescriptor)triggerHandle.getDescriptor().orElseThrow(() -> new IllegalStateException());
        TriggerProcessorState state = (TriggerProcessorState)triggerProcessor.getState().orElseThrow(() -> new IllegalStateException(String.format("Processor '%s' of trigger '%s' is not realized", triggerProcessor.getId(), triggerHandle.getId())));
        Class[] classArray = desc.getSupportedContexts();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (state.supportsContext(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

