/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.util;

import javax.servlet.http.HttpServletRequest;

public final class Requests {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";

    private Requests() {
    }

    public static boolean isNotModified(HttpServletRequest request, long lastModified) {
        if (lastModified < 0L) {
            return false;
        }
        long modifiedSince = Requests.getIfModifiedSince(request);
        if (modifiedSince <= 0L) {
            return false;
        }
        return lastModified >= modifiedSince;
    }

    private static long getIfModifiedSince(HttpServletRequest request) {
        try {
            return request.getDateHeader(IF_MODIFIED_SINCE);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getOriginalPath(HttpServletRequest request) {
        Object val = request.getAttribute("javax.servlet.forward.servlet_path");
        if (val instanceof String) {
            return (String)val;
        }
        return request.getServletPath();
    }

    public static String getRequestPath(HttpServletRequest request) {
        return request.getServletPath();
    }
}

