/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common.unique;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.AddingContext;
import org.eclipse.packagedrone.repo.channel.Veto;
import org.eclipse.packagedrone.repo.channel.VetoPolicy;
import org.eclipse.packagedrone.repo.channel.search.Predicate;
import org.eclipse.packagedrone.repo.channel.search.Predicates;
import org.eclipse.packagedrone.repo.channel.search.SearchOptions;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.common.unique.UniqueArtifactConfiguration;

public class UniqueArtifactProcessor
implements Processor {
    private static final Escaper ESC = HtmlEscapers.htmlEscaper();
    private final UniqueArtifactConfiguration cfg;

    public UniqueArtifactProcessor(UniqueArtifactConfiguration cfg) {
        this.cfg = cfg;
    }

    public void streamHtmlState(PrintWriter writer) {
        writer.format("Ensure that all artifacts with the key%s %s have the same value in <code>%s</code> by: %s.", this.cfg.getKeys().length > 1 ? "s" : "", this.format(this.cfg.getKeys()), UniqueArtifactProcessor.format(this.cfg.getUniqueAttribute()), this.format(this.cfg.getVetoPolicy()));
        if (this.cfg.isSkipMissingAttributes()) {
            writer.format(" Artifacts with missing <q>artifact keys</q> will not be checked.", new Object[0]);
        }
    }

    private Object format(VetoPolicy vetoPolicy) {
        switch (vetoPolicy) {
            case FAIL: {
                return "failing the operation";
            }
        }
        return "not adding the artifact";
    }

    private String format(MetaKey[] keys) {
        return Arrays.stream(keys).map(key -> String.format("<code>%s</code>", UniqueArtifactProcessor.format(key))).collect(Collectors.joining(", "));
    }

    private static String format(MetaKey metaKey) {
        if (metaKey == null) {
            return "";
        }
        return ESC.escape(metaKey.toString());
    }

    public void process(Object context) {
        AddingContext ctx = (AddingContext)context;
        HashMap<MetaKey, String> target = new HashMap<MetaKey, String>(this.cfg.getKeys().length);
        MetaKey[] metaKeyArray = this.cfg.getKeys();
        int n = metaKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetaKey key = metaKeyArray[n2];
            String keyValue = (String)ctx.getMetaData().get(key);
            if (keyValue == null && this.cfg.isSkipMissingAttributes()) {
                return;
            }
            target.put(key, keyValue);
            ++n2;
        }
        String newUniqueValue = (String)ctx.getMetaData().get(this.cfg.getUniqueAttribute());
        if (newUniqueValue == null) {
            return;
        }
        if (((Optional)ctx.getArtifactLocator().process(this.makePredicate(target, newUniqueValue), this.makeOptions(), stream -> stream.findAny())).isPresent()) {
            ctx.vetoAdd(this.makeVeto(newUniqueValue));
        }
    }

    private Veto makeVeto(String newUniqueValue) {
        String reason = this.cfg.getReason();
        if (reason == null) {
            String fields = Arrays.stream(this.cfg.getKeys()).map(o -> "'" + o + "'").collect(Collectors.joining(", "));
            reason = String.format("There is a least one artifact with the same values of %s but a different value of '%s' than '%s'", fields, this.cfg.getUniqueAttribute(), newUniqueValue);
        }
        return new Veto(this.cfg.getVetoPolicy(), reason);
    }

    private SearchOptions makeOptions() {
        SearchOptions.Builder builder = new SearchOptions.Builder();
        builder.limit(1L);
        return builder.build();
    }

    private Predicate makePredicate(Map<MetaKey, String> target, String uniqueValue) {
        LinkedList<Predicate> ands = new LinkedList<Predicate>();
        for (Map.Entry<MetaKey, String> entry : target.entrySet()) {
            ands.add(Predicates.equal((MetaKey)entry.getKey(), Optional.ofNullable(entry.getValue())));
        }
        ands.add(Predicates.not((Predicate)Predicates.equal((MetaKey)this.cfg.getUniqueAttribute(), (String)uniqueValue)));
        return Predicates.and(ands);
    }
}

