/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.transfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.api.transfer.ContentProvider;
import org.eclipse.packagedrone.repo.api.transfer.TransferWriterEntryContext;
import org.eclipse.packagedrone.utils.io.CloseShieldOutputStream;

public class TransferArchiveWriter
implements AutoCloseable,
TransferWriterEntryContext {
    private final ZipOutputStream stream;

    public TransferArchiveWriter(OutputStream stream) {
        this.stream = new ZipOutputStream(stream, StandardCharsets.UTF_8);
    }

    @Override
    public TransferWriterEntryContext createEntry(String name, Map<MetaKey, String> properties, ContentProvider content) throws IOException {
        return this.store(Collections.emptyList(), name, properties, content);
    }

    private TransferWriterEntryContext store(List<String> parents, String name, Map<MetaKey, String> properties, ContentProvider content) throws IOException {
        final ArrayList<String> newParents = new ArrayList<String>(parents.size());
        newParents.addAll(parents);
        name = name.replace(File.separatorChar, '/');
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            newParents.add(name.substring(idx + 1, name.length() - 1));
        } else {
            newParents.add(name);
        }
        String basename = this.makeBaseName(newParents);
        if (idx >= 0) {
            this.addEntry(String.valueOf(basename) + "/name", ContentProvider.string(name));
        }
        this.addEntry(String.valueOf(basename) + "/properties.json", output -> this.writeProperties(properties, output));
        this.addEntry(String.valueOf(basename) + "/content", content);
        return new TransferWriterEntryContext(){

            @Override
            public TransferWriterEntryContext createEntry(String name, Map<MetaKey, String> properties, ContentProvider content) throws IOException {
                return TransferArchiveWriter.this.store(newParents, name, properties, content);
            }
        };
    }

    private void addEntry(String name, ContentProvider provider) throws IOException {
        this.stream.putNextEntry(new ZipEntry(name));
        provider.provide((OutputStream)new CloseShieldOutputStream((OutputStream)this.stream));
        this.stream.closeEntry();
    }

    protected void writeProperties(Map<MetaKey, String> properties, OutputStream stream) throws IOException {
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        MetaKeys.writeJson(properties, (Writer)new OutputStreamWriter(stream, StandardCharsets.UTF_8));
    }

    private String makeBaseName(List<String> parents) {
        StringBuilder sb = new StringBuilder();
        for (String segment : parents) {
            sb.append("/artifacts/").append(segment);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

