/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.ConversionException;
import org.eclipse.packagedrone.utils.converter.Converter;

public class StringToLongConverter
implements Converter {
    public static final StringToLongConverter INSTANCE = new StringToLongConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        return from.equals(String.class) && to.equals(Long.class);
    }

    @Override
    public Long convertTo(Object value, Class<?> clazz, ConversionContext context) {
        block4: {
            if (value == null) {
                return null;
            }
            try {
                String str = value.toString();
                if (!str.isEmpty()) break block4;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException(String.format("'%s' is not a number", value));
            }
        }
        return Long.parseLong(value.toString());
    }
}

