/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.importer.ImportContext;
import org.eclipse.packagedrone.repo.importer.Importer;
import org.eclipse.packagedrone.repo.importer.ImporterDescription;
import org.eclipse.packagedrone.repo.importer.SimpleImporterDescription;
import org.eclipse.packagedrone.repo.importer.http.Configuration;
import org.eclipse.packagedrone.utils.Strings;
import org.eclipse.packagedrone.web.LinkTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpImporter
implements Importer {
    private static final Logger logger = LoggerFactory.getLogger(HttpImporter.class);
    public static final String ID = "http";
    private static final SimpleImporterDescription DESCRIPTION;
    private static final int COPY_BUFFER_SIZE;
    private final Gson gson = new GsonBuilder().create();

    static {
        COPY_BUFFER_SIZE = Integer.getInteger("drone.importer.http.copyBufferSize", 40960);
        DESCRIPTION = new SimpleImporterDescription();
        DESCRIPTION.setId(ID);
        DESCRIPTION.setLabel("HTTP Importer");
        DESCRIPTION.setDescription("Import artifacts by downloading the provided URL");
        DESCRIPTION.setStartTarget(new LinkTarget("/import/{token}/http/start"));
    }

    public ImporterDescription getDescription() {
        return DESCRIPTION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runImport(ImportContext context, String configuration) throws Exception {
        String name;
        Path file;
        block18: {
            Configuration cfg = (Configuration)this.gson.fromJson(configuration, Configuration.class);
            logger.debug("Get URL: {}", (Object)cfg.getUrl());
            URL url = new URL(cfg.getUrl());
            file = Files.createTempFile("import", null, new FileAttribute[0]);
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", VersionInformation.USER_AGENT);
            JobInstance.Context job = context.getJobContext();
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try {
                    InputStream in = con.getInputStream();
                    try {
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.toFile()));){
                            long length = con.getContentLengthLong();
                            if (length > 0L) {
                                job.beginWork(String.format("Downloading %s", Strings.bytes((long)length)), length);
                            }
                            byte[] buffer = new byte[COPY_BUFFER_SIZE];
                            while (true) {
                                int rc;
                                if ((rc = in.read(buffer)) <= 0) {
                                    job.complete();
                                    name = HttpImporter.makeName(cfg, url, con);
                                    if (name != null) break;
                                    throw new IllegalStateException(String.format("Unable to determine name for %s", cfg.getUrl()));
                                }
                                ((OutputStream)out).write(buffer, 0, rc);
                                job.worked((long)rc);
                            }
                        }
                        if (in == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.debug("Failed to download", (Throwable)e);
                Files.deleteIfExists(file);
                throw e;
            }
        }
        context.scheduleImport(file, name);
    }

    public static String makeName(Configuration cfg, URL url, URLConnection con) {
        String name = cfg.getAlternateName();
        if (name == null || name.isEmpty()) {
            name = HttpImporter.fromContentDisposition(con.getHeaderField("Content-Disposition"));
        }
        if (name == null || name.isEmpty()) {
            name = HttpImporter.fromPath(url.getPath());
        }
        return name;
    }

    private static String fromContentDisposition(String field) {
        if (field == null || field.isEmpty()) {
            return null;
        }
        try {
            ContentDisposition cd = new ContentDisposition(field);
            return cd.getParameter("filename");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static String fromPath(String path) {
        if (path == null) {
            return null;
        }
        String[] segs = path.split("/");
        if (segs.length == 0) {
            return null;
        }
        return segs[segs.length - 1];
    }
}

