/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class QuickAccessExtensionManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.quickAccess";
    private static final String COMPUTER_TAG = "computer";

    public static Collection<QuickAccessProvider> getProviders(Runnable onActivate) {
        return Arrays.stream(Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID)).filter(element -> COMPUTER_TAG.equals(element.getName())).map(element -> new QuickAccessProviderExtensionProxy((IConfigurationElement)element, onActivate)).collect(Collectors.toList());
    }

    private static class QuickAccessProviderExtensionProxy
    extends QuickAccessProvider {
        private static final String NAME_ATTRIBUTE = "name";
        private static final String REQUIRES_UI_ACCESS_ATTRIBUTE = "requiresUIAccess";
        private final Bundle bundle;
        private final IConfigurationElement extension;
        private final QuickAccessElement[] activateElement;
        private IQuickAccessComputer computer;

        public QuickAccessProviderExtensionProxy(IConfigurationElement extension, final Runnable onActivate) {
            this.bundle = Platform.getBundle((String)extension.getContributor().getName());
            this.extension = extension;
            this.activateElement = new QuickAccessElement[]{new QuickAccessElement(){

                @Override
                public String getLabel() {
                    return NLS.bind((String)QuickAccessMessages.get().QuickAccessContents_activate, (Object)this.getName());
                }

                @Override
                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                @Override
                public String getId() {
                    return "activate-" + this.getId();
                }

                @Override
                public void execute() {
                    try {
                        bundle.start(1);
                        this.reset();
                        if (onActivate != null) {
                            onActivate.run();
                        }
                    }
                    catch (BundleException e) {
                        WorkbenchPlugin.log(e);
                    }
                }
            }};
        }

        private boolean canDelegate() {
            if (this.bundle != null && this.bundle.getState() == 32) {
                if (this.computer == null) {
                    try {
                        this.computer = (IQuickAccessComputer)this.extension.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        WorkbenchPlugin.log(e);
                    }
                }
                return this.computer != null;
            }
            return false;
        }

        @Override
        public boolean requiresUiAccess() {
            return Boolean.parseBoolean(this.extension.getAttribute(REQUIRES_UI_ACCESS_ATTRIBUTE));
        }

        @Override
        public String getName() {
            return this.extension.getAttribute(NAME_ATTRIBUTE);
        }

        @Override
        public String getId() {
            return String.valueOf(this.bundle.getSymbolicName()) + '/' + this.extension.getAttribute("class");
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        @Override
        public QuickAccessElement[] getElementsSorted(String filter, IProgressMonitor monitor) {
            if (this.canDelegate()) {
                boolean[] needsRefresh = new boolean[1];
                SafeRunner.run(() -> {
                    blArray[0] = this.computer.needsRefresh();
                    return blArray[0];
                });
                if (needsRefresh[0]) {
                    this.reset();
                }
                return super.getElementsSorted(filter, monitor);
            }
            return this.activateElement;
        }

        @Override
        public QuickAccessElement[] getElements() {
            if (this.canDelegate()) {
                QuickAccessElement[][] elements = new QuickAccessElement[1][];
                SafeRunner.run(() -> {
                    quickAccessElementArray[0] = this.computer.computeElements();
                    return quickAccessElementArray[0];
                });
                return elements[0];
            }
            return this.activateElement;
        }

        @Override
        public QuickAccessElement[] getElements(String filter, IProgressMonitor monitor) {
            if (this.canDelegate()) {
                if (this.computer instanceof IQuickAccessComputerExtension) {
                    QuickAccessElement[][] elements = new QuickAccessElement[1][];
                    SafeRunner.run(() -> {
                        quickAccessElementArray[0] = ((IQuickAccessComputerExtension)this.computer).computeElements(filter, monitor);
                        return quickAccessElementArray[0];
                    });
                    return elements[0];
                }
                return new QuickAccessElement[0];
            }
            return this.activateElement;
        }

        @Override
        protected void doReset() {
            if (this.canDelegate()) {
                SafeRunner.run(this.computer::resetState);
            }
        }

        @Override
        public QuickAccessElement findElement(String id, String filterText) {
            QuickAccessElement[] elementsSorted = this.getElementsSorted(filterText, (IProgressMonitor)new NullProgressMonitor());
            return Arrays.stream(elementsSorted).filter(element -> element.getId().equals(id)).findAny().orElse(null);
        }
    }
}

