/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.util.Objects;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class AbstractStringToNumberConverter<T extends Number>
extends NumberFormatConverter<Object, T> {
    private Class<?> toType;
    private Format numberFormat;
    private final Number min;
    private final Number max;
    private final Class<?> boxedType;
    protected static final Integer MIN_INTEGER = Integer.MIN_VALUE;
    protected static final Integer MAX_INTEGER = Integer.MAX_VALUE;
    protected static final Double MIN_DOUBLE = -1.7976931348623157E308;
    protected static final Double MAX_DOUBLE = Double.MAX_VALUE;
    protected static final Long MIN_LONG = Long.MIN_VALUE;
    protected static final Long MAX_LONG = Long.MAX_VALUE;
    protected static final Float MIN_FLOAT = Float.valueOf(-3.4028235E38f);
    protected static final Float MAX_FLOAT = Float.valueOf(Float.MAX_VALUE);
    protected static final Short MIN_SHORT = Short.MIN_VALUE;
    protected static final Short MAX_SHORT = Short.MAX_VALUE;
    protected static final Byte MIN_BYTE = -128;
    protected static final Byte MAX_BYTE = 127;
    static Class<?> icuBigDecimal = null;
    static Method icuBigDecimalScale = null;
    static Method icuBigDecimalUnscaledValue = null;

    protected AbstractStringToNumberConverter(Format numberFormat, Class<T> toType, Number min, Number max, Class<T> boxedType) {
        super(String.class, toType, numberFormat);
        try {
            icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            icuBigDecimalScale = icuBigDecimal.getMethod("scale", new Class[0]);
            icuBigDecimalUnscaledValue = icuBigDecimal.getMethod("unscaledValue", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {}
        this.toType = Objects.requireNonNull(toType);
        this.numberFormat = Objects.requireNonNull(numberFormat);
        this.min = min;
        this.max = max;
        this.boxedType = Objects.requireNonNull(boxedType);
    }

    @Override
    public T convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.toType.isPrimitive());
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (Integer.class.equals(this.boxedType)) {
            if (StringToNumberParser.inIntegerRange(result.getNumber())) {
                return (T)Integer.valueOf(result.getNumber().intValue());
            }
        } else if (Double.class.equals(this.boxedType)) {
            if (StringToNumberParser.inDoubleRange(result.getNumber())) {
                return (T)Double.valueOf(result.getNumber().doubleValue());
            }
        } else if (Long.class.equals(this.boxedType)) {
            if (StringToNumberParser.inLongRange(result.getNumber())) {
                return (T)Long.valueOf(result.getNumber().longValue());
            }
        } else if (Float.class.equals(this.boxedType)) {
            if (StringToNumberParser.inFloatRange(result.getNumber())) {
                return (T)Float.valueOf(result.getNumber().floatValue());
            }
        } else {
            if (BigInteger.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return (T)BigInteger.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return (T)n;
                }
                if (n instanceof BigDecimal) {
                    return (T)((BigDecimal)n).toBigInteger();
                }
                return (T)BigDecimal.valueOf(n.doubleValue()).toBigInteger();
            }
            if (BigDecimal.class.equals(this.boxedType)) {
                Number n = result.getNumber();
                if (n instanceof Long) {
                    return (T)BigDecimal.valueOf(n.longValue());
                }
                if (n instanceof BigInteger) {
                    return (T)new BigDecimal((BigInteger)n);
                }
                if (n instanceof BigDecimal) {
                    return (T)n;
                }
                if (icuBigDecimal != null && icuBigDecimal.isInstance(n)) {
                    try {
                        int scale = (Integer)icuBigDecimalScale.invoke((Object)n, new Object[0]);
                        BigInteger unscaledValue = (BigInteger)icuBigDecimalUnscaledValue.invoke((Object)n, new Object[0]);
                        return (T)new BigDecimal(unscaledValue, scale);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalArgumentException("Error (IllegalAccessException) converting BigDecimal using ICU");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IllegalArgumentException("Error (InvocationTargetException) converting BigDecimal using ICU");
                    }
                }
                if (n instanceof Double) {
                    BigDecimal bd = BigDecimal.valueOf(n.doubleValue());
                    if (bd.scale() == 0) {
                        return (T)bd;
                    }
                    throw new IllegalArgumentException("Non-integral Double value returned from NumberFormat which cannot be accurately stored in a BigDecimal due to lost precision. Consider using ICU4J or Java 5 which can properly format and parse these types.");
                }
            } else if (Short.class.equals(this.boxedType)) {
                if (StringToNumberParser.inShortRange(result.getNumber())) {
                    return (T)Short.valueOf(result.getNumber().shortValue());
                }
            } else if (Byte.class.equals(this.boxedType) && StringToNumberParser.inByteRange(result.getNumber())) {
                return (T)Byte.valueOf(result.getNumber().byteValue());
            }
        }
        if (this.min != null && this.max != null) {
            throw new IllegalArgumentException(StringToNumberParser.createOutOfRangeMessage(this.min, this.max, this.numberFormat));
        }
        throw new IllegalArgumentException("Could not convert [" + String.valueOf(fromObject) + "] to type [" + String.valueOf(this.toType) + "]");
    }
}

