/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationChainImpl
extends BasicEList<Notification>
implements NotificationChain {
    private static final long serialVersionUID = 1L;
    private Map<Object, Object> notifierIndex;

    public NotificationChainImpl() {
    }

    public NotificationChainImpl(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected Object[] newData(int capacity) {
        return new Notification[capacity];
    }

    @Override
    public boolean add(Notification newNotification) {
        if (newNotification == null) {
            return false;
        }
        Notification[] notifications = (Notification[])this.data;
        if (this.size >= 1000) {
            if (this.notifierIndex == null) {
                this.notifierIndex = new HashMap<Object, Object>(this.size + 1);
                int i = 0;
                while (i < this.size) {
                    this.addToIndex(notifications[i], false);
                    ++i;
                }
            }
            if (!this.addToIndex(newNotification, true)) {
                return false;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                Notification notification = notifications[i];
                if (notification.merge(newNotification)) {
                    return false;
                }
                ++i;
            }
        }
        return super.add(newNotification);
    }

    private boolean addToIndex(Notification newNotification, boolean merge) {
        Object notifier = newNotification.getNotifier();
        Object otherNotification = this.notifierIndex.put(notifier, newNotification);
        if (otherNotification != null) {
            if (otherNotification instanceof Notification) {
                Notification notification = (Notification)otherNotification;
                if (merge && notification.merge(newNotification)) {
                    this.notifierIndex.put(notifier, otherNotification);
                    return false;
                }
                this.notifierIndex.put(notifier, new Notification[]{notification, newNotification});
            } else {
                Notification[] otherNotifications = (Notification[])otherNotification;
                if (merge) {
                    int i = 0;
                    while (i < otherNotifications.length) {
                        Notification notification = otherNotifications[i];
                        if (notification.merge(newNotification)) {
                            this.notifierIndex.put(notifier, otherNotifications);
                            return false;
                        }
                        ++i;
                    }
                }
                Notification[] newNotifications = new Notification[otherNotifications.length + 1];
                System.arraycopy(otherNotifications, 0, newNotifications, 0, otherNotifications.length);
                newNotifications[otherNotifications.length] = newNotification;
                this.notifierIndex.put(notifier, newNotifications);
            }
        }
        return true;
    }

    @Override
    public void dispatch() {
        Notification[] notifications = (Notification[])this.data;
        int i = 0;
        while (i < this.size) {
            Notification notification = notifications[i];
            this.dispatch(notification);
            ++i;
        }
    }

    protected void dispatch(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier != null && notification.getEventType() != -1) {
            ((Notifier)notifier).eNotify(notification);
        }
    }
}

