/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.framework.device.ui.wizard.DeviceWizardResources;
import org.eclipse.tml.framework.device.ui.wizard.IWizardCustomizer;
import org.eclipse.tml.framework.device.ui.wizard.WizardNewProjectPage;
import org.eclipse.tml.framework.device.ui.wizard.WizardNewPropertyPage;

public class DeviceWizardBean {
    public String extensionId;
    private boolean needsProgressMonitor;
    private boolean forcePreviousAndNextButtons;
    private boolean canFinishEarly;
    private String image;
    private String title;
    private String customizerName;
    private IWizardCustomizer customizer;
    private String projectDescription;
    private String projectTitle;
    private String propertyDescription;
    private String propertyTitle;
    private String propertyXML;
    private String otherDescription;
    private String otherTitle;

    protected DeviceWizardBean(String id) {
        this.extensionId = id;
        this.needsProgressMonitor = Boolean.parseBoolean(PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"settings", (String)"needsProgressMonitor"));
        this.forcePreviousAndNextButtons = Boolean.parseBoolean(PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"settings", (String)"forcePreviousAndNextButtons"));
        this.canFinishEarly = Boolean.parseBoolean(PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"settings", (String)"canFinishEarly"));
        this.image = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"settings", (String)"image");
        this.title = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"settings", (String)"title");
        this.customizer = null;
        this.customizerName = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"customizer", (String)"class");
        if (this.customizerName != null) {
            try {
                this.customizer = (IWizardCustomizer)PluginUtils.getExecutable((String)this.extensionId, (String)"customizer");
            }
            catch (CoreException e) {
                BasePlugin.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        this.projectDescription = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"project", (String)"title");
        this.projectTitle = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"project", (String)"description");
        this.propertyDescription = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"property", (String)"title");
        this.propertyTitle = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"property", (String)"description");
        this.propertyXML = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"property", (String)"xml");
        this.otherDescription = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"other", (String)"title");
        this.otherTitle = PluginUtils.getPluginAttribute((String)"org.eclipse.tml.device.ui.newDeviceWizardPages", (String)this.extensionId, (String)"other", (String)"description");
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public boolean forcePreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons;
    }

    public boolean canFinishEarly() {
        return this.canFinishEarly;
    }

    public String getImage() {
        return this.image;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasProjectPage() {
        return this.customizer != null && this.customizer.hasCustomizedProjectPage();
    }

    public WizardPage getProjectPage() {
        Object page = null;
        page = this.hasProjectPage() ? this.customizer.getCustomizedProjectPage() : new WizardNewProjectPage("projectPage");
        return page;
    }

    public String getProjectTitle() {
        if (this.projectTitle == null) {
            this.projectTitle = DeviceWizardResources.TML_Emulator_Wizard_Project_Title;
        }
        return this.projectTitle;
    }

    public String getProjectDescription() {
        if (this.projectDescription == null) {
            this.projectDescription = DeviceWizardResources.TML_Emulator_Wizard_Project_Description;
        }
        return this.projectDescription;
    }

    public boolean hasPropertyPage() {
        return this.customizer != null && this.customizer.hasCustomizedPropertyPage();
    }

    public WizardPage getPropertyPage() {
        Object page = null;
        page = this.hasPropertyPage() ? this.customizer.getCustomizedPropertyPage() : new WizardNewPropertyPage("propertyPage");
        return page;
    }

    public String getPropertyTitle() {
        return this.propertyTitle;
    }

    public String getPropertyDescription() {
        return this.propertyDescription;
    }

    public String getPropertyXML() {
        return this.propertyXML;
    }

    public boolean hasOtherPage() {
        return this.customizer != null && this.customizer.hasCustomizedOtherPage();
    }

    public WizardPage getOtherPage() {
        WizardPage page = this.customizer.getCustomizedOtherPage();
        if (page == null) {
            page = null;
        }
        return page;
    }

    public String getOtherTitle() {
        return this.otherTitle;
    }

    public String getOtherDescription() {
        return this.otherDescription;
    }
}

