/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.cpuload;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.tools.cpuload.Messages;

public class DialogOptions
extends TitleAreaDialog {
    private final String WINDOW_TITLE = Messages.OptionsDialog_Window_Title;
    private final String WINDOW_MESSAGE = Messages.OptionsDialog_Window_Message;
    private final String LABEL_REFRESH = Messages.OptionsDialog_Label_Refresh_Rate;
    private final String LABEL_TIMEUNIT = "ms";
    private Spinner spinner;
    private ITool tool = null;

    public DialogOptions(Shell parent, ITool tool) {
        super(parent);
        this.tool = tool;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.WINDOW_TITLE);
        this.setMessage(this.WINDOW_MESSAGE);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginLeft = 7;
        gridLayout.marginRight = 7;
        dialogArea.setLayout((Layout)gridLayout);
        dialogArea.setLayoutData((Object)new GridData(1808));
        dialogArea.setFont(parent.getFont());
        Label refreshLabel = new Label(dialogArea, 0);
        refreshLabel.setText(this.LABEL_REFRESH);
        this.spinner = new Spinner(dialogArea, 2048);
        Label timeUnit = new Label(dialogArea, 0);
        timeUnit.setText("ms");
        this.spinner.setMinimum(0);
        this.spinner.setMaximum(50000);
        this.spinner.setSelection(this.tool.getRefreshDelay());
        this.spinner.setIncrement(100);
        this.spinner.setPageIncrement(500);
        this.spinner.pack();
        return dialogArea;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected void okPressed() {
        this.tool.setRefreshDelay(this.spinner.getSelection());
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

