/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptActionHandler;
import org.eclipse.smarthome.automation.module.script.internal.handler.ScriptConditionHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ModuleHandlerFactory.class})
public class ScriptModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(ScriptModuleHandlerFactory.class);
    @NonNullByDefault(value={})
    private ScriptEngineManager scriptEngineManager;
    private static final Collection<String> TYPES = Arrays.asList("script.ScriptAction", "script.ScriptCondition");

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void unsetScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = null;
    }

    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        String moduleTypeUID = module.getTypeUID();
        if (moduleTypeUID != null) {
            if ("script.ScriptCondition".equals(moduleTypeUID) && module instanceof Condition) {
                ScriptConditionHandler handler = new ScriptConditionHandler((Condition)module, ruleUID, this.scriptEngineManager);
                return handler;
            }
            if ("script.ScriptAction".equals(moduleTypeUID) && module instanceof Action) {
                ScriptActionHandler handler = new ScriptActionHandler((Action)module, ruleUID, this.scriptEngineManager);
                return handler;
            }
            this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        } else {
            this.logger.error("ModuleType is not registered: {}", (Object)moduleTypeUID);
        }
        return null;
    }
}

