/**
 * Copyright (c) 2014,2019 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.rule;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smarthome.model.rule.RulesRuntimeModule;
import org.eclipse.smarthome.model.rule.RulesStandaloneSetupGenerated;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.ScriptStandaloneSetup;
import org.eclipse.smarthome.model.script.ServiceModule;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.xtext.resource.IResourceServiceProvider;

/**
 * Initialization support for running Xtext languages
 * without equinox extension registry
 */
@SuppressWarnings("all")
public class RulesStandaloneSetup extends RulesStandaloneSetupGenerated {
  private static Injector injector;
  
  private ScriptServiceUtil scriptServiceUtil;
  
  private ScriptEngine scriptEngine;
  
  @Override
  public Injector createInjectorAndDoEMFRegistration() {
    ScriptStandaloneSetup.doSetup(this.scriptServiceUtil, this.scriptEngine);
    final Injector injector = this.createInjector();
    this.register(injector);
    return injector;
  }
  
  public RulesStandaloneSetup setScriptServiceUtil(final ScriptServiceUtil scriptServiceUtil) {
    this.scriptServiceUtil = scriptServiceUtil;
    return this;
  }
  
  public RulesStandaloneSetup setScriptEngine(final ScriptEngine scriptEngine) {
    this.scriptEngine = scriptEngine;
    return this;
  }
  
  public ScriptServiceUtil getScriptServiceUtil() {
    return this.scriptServiceUtil;
  }
  
  public ScriptEngine getScriptEngine() {
    return this.scriptEngine;
  }
  
  public static void doSetup(final ScriptServiceUtil scriptServiceUtil, final ScriptEngine scriptEngine) {
    if ((RulesStandaloneSetup.injector == null)) {
      RulesStandaloneSetup.injector = new RulesStandaloneSetup().setScriptServiceUtil(scriptServiceUtil).setScriptEngine(scriptEngine).createInjectorAndDoEMFRegistration();
    }
  }
  
  @Override
  public Injector createInjector() {
    ServiceModule _serviceModule = new ServiceModule(this.scriptServiceUtil, this.scriptEngine);
    RulesRuntimeModule _rulesRuntimeModule = new RulesRuntimeModule();
    return Guice.createInjector(_serviceModule, _rulesRuntimeModule);
  }
  
  public static Injector getInjector() {
    return RulesStandaloneSetup.injector;
  }
  
  public static Injector unregister() {
    Injector _xblockexpression = null;
    {
      EPackage.Registry.INSTANCE.remove("http://www.eclipse.org/smarthome/model/Rules");
      Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().remove("rules");
      IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().remove("rules");
      _xblockexpression = RulesStandaloneSetup.injector = null;
    }
    return _xblockexpression;
  }
}
